/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.managers;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.Permission;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.templates.Template;
import cc.unilock.nilcord.lib.jda.api.exceptions.InsufficientPermissionException;
import cc.unilock.nilcord.lib.jda.api.managers.TemplateManager;
import cc.unilock.nilcord.lib.jda.api.requests.Route;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataObject;
import cc.unilock.nilcord.lib.jda.internal.managers.ManagerBase;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import cc.unilock.nilcord.lib.okhttp3.RequestBody;

public class TemplateManagerImpl
extends ManagerBase<TemplateManager>
implements TemplateManager {
    protected final Template template;
    protected final JDA api;
    protected String name;
    protected String description;

    public TemplateManagerImpl(Template template) {
        super(template.getJDA(), Route.Templates.MODIFY_TEMPLATE.compile(template.getGuild().getId(), template.getCode()));
        this.template = template;
        this.api = template.getJDA();
        if (TemplateManagerImpl.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public TemplateManagerImpl reset(long fields) {
        super.reset(fields);
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        if ((fields & 2L) == 2L) {
            this.description = null;
        }
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public TemplateManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public TemplateManagerImpl reset() {
        super.reset();
        this.name = null;
        this.description = null;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public TemplateManagerImpl setName(@Nonnull String name) {
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 100, "Name");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public TemplateManagerImpl setDescription(@Nullable String description) {
        if (description != null) {
            Checks.notLonger(this.name, 120, "Description");
        }
        this.description = description;
        this.set |= 2L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject body = DataObject.empty();
        if (this.shouldUpdate(1L)) {
            body.put("name", this.name);
        }
        if (this.shouldUpdate(2L)) {
            body.put("description", this.name);
        }
        this.reset();
        return this.getRequestBody(body);
    }

    @Override
    protected boolean checkPermissions() {
        Guild guild = this.api.getGuildById(this.template.getGuild().getIdLong());
        if (guild == null) {
            return true;
        }
        if (!guild.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(guild, Permission.MANAGE_SERVER);
        }
        return super.checkPermissions();
    }
}

