/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.kaleido.lib.nightconfig.toml;

import cc.unilock.nilcord.lib.kaleido.lib.nightconfig.core.io.CharacterOutput;
import cc.unilock.nilcord.lib.kaleido.lib.nightconfig.toml.TomlWriter;
import cc.unilock.nilcord.lib.kaleido.lib.nightconfig.toml.ValueWriter;
import java.util.Iterator;
import java.util.List;

final class ArrayWriter {
    private static final char[] EMPTY_ARRAY = new char[]{'[', ']'};
    static final char[] ELEMENT_SEPARATOR = new char[]{',', ' '};

    static void write(List<?> values, CharacterOutput output, TomlWriter writer) {
        if (values.isEmpty()) {
            output.write(EMPTY_ARRAY);
            return;
        }
        output.write('[');
        boolean indent = writer.writesIndented(values);
        if (indent) {
            writer.increaseIndentLevel();
        }
        Iterator<?> iterator2 = values.iterator();
        boolean hasNext = iterator2.hasNext();
        while (hasNext) {
            if (indent) {
                writer.writeNewline(output);
                writer.writeIndent(output);
            }
            Object value = iterator2.next();
            ValueWriter.write(value, output, writer);
            hasNext = iterator2.hasNext();
            if (!hasNext) continue;
            if (indent) {
                output.write(',');
                continue;
            }
            output.write(ELEMENT_SEPARATOR);
        }
        if (indent) {
            writer.decreaseIndentLevel();
            writer.writeNewline(output);
            writer.writeIndent(output);
        }
        output.write(']');
    }

    private ArrayWriter() {
    }
}

