/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.impl.tree;

import cc.unilock.nilcord.lib.jetbrains_annotations.NotNull;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.metadata.MetadataType;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.values.ValueKey;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.values.ValueTreeNode;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.impl.AbstractMetadataContainer;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.impl.tree.Trie;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SectionTreeNode
extends AbstractMetadataContainer
implements ValueTreeNode.Section {
    private final Trie.Node node;

    public SectionTreeNode(Trie.Node node, Map<MetadataType<?, ?>, Object> metadata) {
        super(metadata);
        this.node = node;
    }

    @Override
    public ValueKey key() {
        return this.node.getKey();
    }

    @Override
    public void propagateInheritedMetadata(Map<MetadataType<?, ?>, Object> inheritedMetadata) {
        for (Map.Entry<MetadataType<?, ?>, Object> entry : inheritedMetadata.entrySet()) {
            this.metadata.putIfAbsent(entry.getKey(), entry.getValue());
        }
        LinkedHashMap inheritorMetadata = new LinkedHashMap();
        for (Map.Entry entry : this.metadata.entrySet()) {
            if (!((MetadataType)entry.getKey()).isInherited()) continue;
            inheritorMetadata.put((MetadataType)entry.getKey(), entry.getValue());
        }
        for (ValueTreeNode node : this) {
            node.propagateInheritedMetadata(inheritorMetadata);
        }
    }

    @Override
    @NotNull
    public Iterator<ValueTreeNode> iterator() {
        return new Iterator<ValueTreeNode>(){
            private final Iterator<Trie.Node> itr;
            {
                this.itr = SectionTreeNode.this.node.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public ValueTreeNode next() {
                return this.itr.next().getValue();
            }
        };
    }
}

