/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.config;

import cc.unilock.nilcord.lib.kaleido.api.ReflectiveConfig;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.ReflectiveConfig;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.annotations.Comment;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.values.TrackedValue;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.values.ValueList;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.impl.Comments;

public class NilcordConfig
extends ReflectiveConfig {
    @Comment(value={"Settings pertaining to Discord itself"})
    public final Discord discord = new Discord();
    @Comment(value={"Settings pertaining to Minecraft itself"})
    public final Minecraft minecraft = new Minecraft();
    @Comment(value={"Settings pertaining to message formatting"})
    public final Formatting formatting = new Formatting();

    public static final class Discord
    extends ReflectiveConfig.Section {
        @Comment(value={"The Discord bot token to use"})
        public final TrackedValue<String> token = this.value("EMPTY");
        @Comment(value={"The Discord channel ID for the bot to send messages to / receive messages from"})
        public final TrackedValue<String> channel_id = this.value("EMPTY");
        @Comment(value={"Settings pertaining to the Discord webhook"})
        public final Webhook webhook = new Webhook();

        public static final class Webhook
        extends ReflectiveConfig.Section {
            @Comment(value={"Whether to use a webhook for sending players' chat messages to Discord"})
            public final TrackedValue<Boolean> enabled = this.value(Boolean.FALSE);
            @Comment(value={"The webhook URL to use"})
            public final TrackedValue<String> url = this.value("EMPTY");
        }
    }

    public static final class Minecraft
    extends ReflectiveConfig.Section {
        @Comment(value={"Whether to allow mentioning Discord users from Minecraft"})
        public final TrackedValue<Boolean> enable_mentions = this.value(Boolean.FALSE);
        @Comment(value={"Whether to allow mentioning @everyone and @here from Minecraft"})
        public final TrackedValue<Boolean> enable_everyone_and_here = this.value(Boolean.FALSE);
        @Comment(value={"Whether to show Discord message attachments in-game"})
        public final TrackedValue<Boolean> show_attachments = this.value(Boolean.TRUE);
        @Comment(value={"Whether to show messages from other Discord bots in-game"})
        public final TrackedValue<Boolean> show_bot_messages = this.value(Boolean.FALSE);
        @Comment(value={"Whether to show messages from Discord webhooks in-game"})
        public final TrackedValue<Boolean> show_webhook_messages = this.value(Boolean.TRUE);
        @Comment(value={"Application / User IDs to ignore messages from"})
        public final TrackedValue<ValueList<String>> ignored_ids = this.list("000000000000000000", new String[0]);
    }

    public static final class Formatting
    extends ReflectiveConfig.Section {
        @Comments(value={@Comment(value={"Settings pertaining to messages visible in Discord"}), @Comment(value={"Available placeholders: <username>"})})
        public final DiscordFormatting discord = new DiscordFormatting();
        @Comments(value={@Comment(value={"Settings pertaining to messages visible in Minecraft"}), @Comment(value={"Available placeholders: <message> <message_url> <nickname> <role_color> <username>"})})
        public final MinecraftFormatting minecraft = new MinecraftFormatting();

        public static final class DiscordFormatting
        extends ReflectiveConfig.Section {
            @Comments(value={@Comment(value={"Server init message"}), @Comment(value={"Available placeholders: N/A"})})
            public final TrackedValue<String> server_init_message = this.value("**Server starting...**");
            @Comments(value={@Comment(value={"Server start message"}), @Comment(value={"Available placeholders: N/A"})})
            public final TrackedValue<String> server_start_message = this.value("**Server started!**");
            @Comments(value={@Comment(value={"Server stop message"}), @Comment(value={"Available placeholders: N/A"})})
            public final TrackedValue<String> server_stop_message = this.value("**Server stopped!**");
            @Comments(value={@Comment(value={"Server crash message"}), @Comment(value={"Available placeholders: N/A"})})
            public final TrackedValue<String> server_crash_message = this.value("**Server crashed :(**");
            @Comments(value={@Comment(value={"Player chat messages"}), @Comment(value={"Additional placeholders: <message>"})})
            public final TrackedValue<String> chat_message = this.value("**<<username>>** <message>");
            @Comments(value={@Comment(value={"Player join messages"}), @Comment(value={"Additional placeholders: N/A"})})
            public final TrackedValue<String> join_message = this.value("> **<username> joined the game**");
            @Comments(value={@Comment(value={"Player leave messages"}), @Comment(value={"Additional placeholders: N/A"})})
            public final TrackedValue<String> leave_message = this.value("> **<username> left the game**");
            @Comments(value={@Comment(value={"Player death messages"}), @Comment(value={"Additional placeholders: <death_message>"})})
            public final TrackedValue<String> death_message = this.value("**<username> died:** _<death_message>_");
            @Comment(value={"Settings pertaining to messages sent from the webhook, if enabled"})
            public final WebhookFormatting webhook = new WebhookFormatting();

            public static final class WebhookFormatting
            extends ReflectiveConfig.Section {
                @Comments(value={@Comment(value={"The URL to use for the webhook's avatar"}), @Comment(value={"Additional placeholders: N/A"})})
                public final TrackedValue<String> avatar_url = this.value("https://visage.surgeplay.com/bust/128/<username>");
                @Comments(value={@Comment(value={"The webhook's username"}), @Comment(value={"Additional placeholders: N/A"})})
                public final TrackedValue<String> username = this.value("<username>");
                @Comments(value={@Comment(value={"Player chat messages"}), @Comment(value={"Additional placeholders: <message>"})})
                public final TrackedValue<String> chat_message = this.value("<message>");
            }
        }

        public static final class MinecraftFormatting
        extends ReflectiveConfig.Section {
            @Comments(value={@Comment(value={"Discord messages"}), @Comment(value={"Additional placeholders: <attachment_format> <discord_format> <reply_format> <username_format>"})})
            public final TrackedValue<String> discord_message = this.value("[Discord] <reply_format><<username_format>> <message><attachment_format>");
            @Comments(value={@Comment(value={"Username format"}), @Comment(value={"Additional placeholders: N/A"})})
            public final TrackedValue<String> username_format = this.value("<nickname>");
            @Comments(value={@Comment(value={"Mention format"}), @Comment(value={"Additional placeholders: N/A"})})
            public final TrackedValue<String> mention_format = this.value("\u00a7n@<nickname>\u00a7r");
            @Comments(value={@Comment(value={"Reply format"}), @Comment(value={"Additional placeholders: <reply_message> <reply_nickname> <reply_role_color> <reply_url> <reply_username>"})})
            public final TrackedValue<String> reply_format = this.value("[\u00a7b\u2190\u00a7r<reply_nickname>] ");
            @Comments(value={@Comment(value={"Attachment format"}), @Comment(value={"Additional placeholders: <attachment_url>"})})
            public final TrackedValue<String> attachment_format = this.value("[ \u00a7bAttachment: \u00a7n<attachment_url>\u00a7r ]");
        }
    }
}

