/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jackson.databind.deser.std;

import cc.unilock.nilcord.lib.jackson.core.JsonParser;
import cc.unilock.nilcord.lib.jackson.databind.DeserializationConfig;
import cc.unilock.nilcord.lib.jackson.databind.DeserializationContext;
import cc.unilock.nilcord.lib.jackson.databind.JavaType;
import cc.unilock.nilcord.lib.jackson.databind.deser.std.StdDeserializer;
import cc.unilock.nilcord.lib.jackson.databind.jsontype.TypeDeserializer;
import cc.unilock.nilcord.lib.jackson.databind.type.LogicalType;
import cc.unilock.nilcord.lib.jackson.databind.util.AccessPattern;
import java.io.IOException;

public abstract class StdScalarDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;

    protected StdScalarDeserializer(Class<?> vc) {
        super(vc);
    }

    protected StdScalarDeserializer(JavaType valueType) {
        super(valueType);
    }

    protected StdScalarDeserializer(StdScalarDeserializer<?> src) {
        super(src);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.ALWAYS_NULL;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromScalar(p, ctxt);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws IOException {
        ctxt.handleBadMerge(this);
        return this.deserialize(p, ctxt);
    }
}

