/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.audio.hooks;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.audio.SpeakingMode;
import cc.unilock.nilcord.lib.jda.api.audio.hooks.ConnectionListener;
import cc.unilock.nilcord.lib.jda.api.audio.hooks.ConnectionStatus;
import cc.unilock.nilcord.lib.jda.api.entities.User;
import cc.unilock.nilcord.lib.jda.api.entities.UserSnowflake;
import cc.unilock.nilcord.lib.slf4j.Logger;
import cc.unilock.nilcord.lib.slf4j.LoggerFactory;
import java.util.EnumSet;

public class ListenerProxy
implements ConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(ListenerProxy.class);
    private volatile ConnectionListener listener = null;

    @Override
    public void onPing(long ping) {
        block4: {
            if (this.listener == null) {
                return;
            }
            ConnectionListener listener = this.listener;
            try {
                if (listener != null) {
                    listener.onPing(ping);
                }
            }
            catch (Throwable t) {
                log.error("The ConnectionListener encountered and uncaught exception", t);
                if (!(t instanceof Error)) break block4;
                throw (Error)t;
            }
        }
    }

    @Override
    public void onStatusChange(@Nonnull ConnectionStatus status) {
        block4: {
            if (this.listener == null) {
                return;
            }
            ConnectionListener listener = this.listener;
            try {
                if (listener != null) {
                    listener.onStatusChange(status);
                }
            }
            catch (Throwable t) {
                log.error("The ConnectionListener encountered and uncaught exception", t);
                if (!(t instanceof Error)) break block4;
                throw (Error)t;
            }
        }
    }

    @Override
    public void onUserSpeakingModeUpdate(@Nonnull UserSnowflake user, @Nonnull EnumSet<SpeakingMode> modes) {
        block5: {
            if (this.listener == null) {
                return;
            }
            ConnectionListener listener = this.listener;
            try {
                if (listener != null) {
                    listener.onUserSpeakingModeUpdate(user, modes);
                    if (user instanceof User) {
                        listener.onUserSpeakingModeUpdate((User)user, modes);
                    }
                }
            }
            catch (Throwable t) {
                log.error("The ConnectionListener encountered and uncaught exception", t);
                if (!(t instanceof Error)) break block5;
                throw (Error)t;
            }
        }
    }

    public void setListener(@Nullable ConnectionListener listener) {
        this.listener = listener;
    }

    public ConnectionListener getListener() {
        return this.listener;
    }
}

