/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.entities.channel;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import java.util.Collection;
import java.util.EnumSet;

public enum ChannelFlag {
    PINNED(2),
    REQUIRE_TAG(16),
    HIDE_MEDIA_DOWNLOAD_OPTIONS(32768);

    private final int value;

    private ChannelFlag(int value) {
        this.value = value;
    }

    public int getRaw() {
        return this.value;
    }

    @Nonnull
    public static EnumSet<ChannelFlag> fromRaw(int bitset) {
        EnumSet<ChannelFlag> set = EnumSet.noneOf(ChannelFlag.class);
        if (bitset == 0) {
            return set;
        }
        for (ChannelFlag flag : ChannelFlag.values()) {
            if (flag.value != bitset) continue;
            set.add(flag);
        }
        return set;
    }

    public static int getRaw(@Nonnull Collection<ChannelFlag> flags) {
        Checks.notNull(flags, "Flags");
        int raw = 0;
        for (ChannelFlag flag : flags) {
            raw |= flag.getRaw();
        }
        return raw;
    }
}

