/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.entities.sticker;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.User;
import cc.unilock.nilcord.lib.jda.api.entities.sticker.RichSticker;
import cc.unilock.nilcord.lib.jda.api.entities.sticker.Sticker;
import cc.unilock.nilcord.lib.jda.api.managers.GuildStickerManager;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.AuditableRestAction;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.CacheRestAction;
import cc.unilock.nilcord.lib.jetbrains_annotations.Contract;

public interface GuildSticker
extends RichSticker {
    @Override
    @Nonnull
    default public Sticker.Type getType() {
        return Sticker.Type.GUILD;
    }

    public boolean isAvailable();

    public long getGuildIdLong();

    @Nonnull
    default public String getGuildId() {
        return Long.toUnsignedString(this.getGuildIdLong());
    }

    @Nullable
    public Guild getGuild();

    @Nullable
    public User getOwner();

    @Nonnull
    @CheckReturnValue
    public CacheRestAction<User> retrieveOwner();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    @Contract(value="->new")
    public GuildStickerManager getManager();
}

