/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.events.guild.update;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.Member;
import cc.unilock.nilcord.lib.jda.api.events.guild.update.GenericGuildUpdateEvent;

public class GuildUpdateOwnerEvent
extends GenericGuildUpdateEvent<Member> {
    public static final String IDENTIFIER = "owner";
    private final long prevId;
    private final long nextId;

    public GuildUpdateOwnerEvent(@Nonnull JDA api, long responseNumber, @Nonnull Guild guild, @Nullable Member oldOwner, long prevId, long nextId) {
        super(api, responseNumber, guild, oldOwner, guild.getOwner(), IDENTIFIER);
        this.prevId = prevId;
        this.nextId = nextId;
    }

    public long getNewOwnerIdLong() {
        return this.nextId;
    }

    @Nonnull
    public String getNewOwnerId() {
        return Long.toUnsignedString(this.nextId);
    }

    public long getOldOwnerIdLong() {
        return this.prevId;
    }

    @Nonnull
    public String getOldOwnerId() {
        return Long.toUnsignedString(this.prevId);
    }

    @Nullable
    public Member getOldOwner() {
        return (Member)this.getOldValue();
    }

    @Nullable
    public Member getNewOwner() {
        return (Member)this.getNewValue();
    }
}

