/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.concrete;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.PermissionOverride;
import cc.unilock.nilcord.lib.jda.api.entities.channel.concrete.Category;
import cc.unilock.nilcord.lib.jda.api.entities.channel.concrete.NewsChannel;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.ChannelAction;
import cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.middleman.StandardGuildMessageChannelMixin;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;

public interface NewsChannelMixin<T extends NewsChannelMixin<T>>
extends NewsChannel,
StandardGuildMessageChannelMixin<T> {
    @Override
    @Nonnull
    default public ChannelAction<NewsChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<NewsChannel> action = guild.createNewsChannel(this.getName()).setNSFW(this.isNSFW()).setTopic(this.getTopic());
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.getPermissionOverrideMap().valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }
}

