/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.handle;

import cc.unilock.nilcord.lib.jda.api.entities.Role;
import cc.unilock.nilcord.lib.jda.api.events.role.RoleCreateEvent;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataObject;
import cc.unilock.nilcord.lib.jda.internal.JDAImpl;
import cc.unilock.nilcord.lib.jda.internal.entities.GuildImpl;
import cc.unilock.nilcord.lib.jda.internal.handle.EventCache;
import cc.unilock.nilcord.lib.jda.internal.handle.SocketHandler;

public class GuildRoleCreateHandler
extends SocketHandler {
    public GuildRoleCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long guildId = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        if (guild == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("GUILD_ROLE_CREATE was received for a Guild that is not yet cached: {}", (Object)content);
            return null;
        }
        Role newRole = this.getJDA().getEntityBuilder().createRole(guild, content.getObject("role"), guild.getIdLong());
        this.getJDA().handleEvent(new RoleCreateEvent(this.getJDA(), this.responseNumber, newRole));
        return null;
    }
}

