/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.managers;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.channel.middleman.AudioChannel;
import cc.unilock.nilcord.lib.jda.api.managers.DirectAudioController;
import cc.unilock.nilcord.lib.jda.internal.JDAImpl;
import cc.unilock.nilcord.lib.jda.internal.requests.WebSocketClient;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;

public class DirectAudioControllerImpl
implements DirectAudioController {
    private final JDAImpl api;

    public DirectAudioControllerImpl(JDAImpl api) {
        this.api = api;
    }

    @Override
    @Nonnull
    public JDAImpl getJDA() {
        return this.api;
    }

    @Override
    public void connect(@Nonnull AudioChannel channel) {
        Checks.notNull(channel, "Audio Channel");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioConnect(channel);
    }

    @Override
    public void disconnect(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioDisconnect(guild);
    }

    @Override
    public void reconnect(@Nonnull AudioChannel channel) {
        Checks.notNull(channel, "Audio Channel");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioReconnect(channel);
    }

    public void update(Guild guild, AudioChannel channel) {
        Checks.notNull(guild, "Guild");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.updateAudioConnection(guild.getIdLong(), channel);
    }
}

