/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.managers;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.entities.StageInstance;
import cc.unilock.nilcord.lib.jda.api.managers.StageInstanceManager;
import cc.unilock.nilcord.lib.jda.api.requests.Route;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataObject;
import cc.unilock.nilcord.lib.jda.internal.managers.ManagerBase;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import cc.unilock.nilcord.lib.okhttp3.RequestBody;

public class StageInstanceManagerImpl
extends ManagerBase<StageInstanceManager>
implements StageInstanceManager {
    private final StageInstance instance;
    private String topic;

    public StageInstanceManagerImpl(StageInstance instance) {
        super(instance.getChannel().getJDA(), Route.StageInstances.UPDATE_INSTANCE.compile(instance.getChannel().getId()));
        this.instance = instance;
    }

    @Override
    @Nonnull
    public StageInstance getStageInstance() {
        return this.instance;
    }

    @Override
    @Nonnull
    public StageInstanceManager setTopic(@Nullable String topic) {
        if (topic != null) {
            topic = topic.trim();
            Checks.notLonger(topic, 120, "Topic");
            if (topic.isEmpty()) {
                topic = null;
            }
        }
        this.topic = topic;
        this.set |= 1L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject body = DataObject.empty();
        if (this.shouldUpdate(1L) && this.topic != null) {
            body.put("topic", this.topic);
        }
        return this.getRequestBody(body);
    }
}

