/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.requests;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.entities.IncomingWebhookClient;
import cc.unilock.nilcord.lib.jda.api.entities.Message;
import cc.unilock.nilcord.lib.jda.api.entities.channel.middleman.MessageChannel;
import cc.unilock.nilcord.lib.jda.api.requests.Route;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.WebhookMessageDeleteAction;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.WebhookMessageRetrieveAction;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataObject;
import cc.unilock.nilcord.lib.jda.internal.JDAImpl;
import cc.unilock.nilcord.lib.jda.internal.entities.AbstractWebhookClient;
import cc.unilock.nilcord.lib.jda.internal.entities.EntityBuilder;
import cc.unilock.nilcord.lib.jda.internal.entities.ReceivedMessage;
import cc.unilock.nilcord.lib.jda.internal.requests.restaction.WebhookMessageCreateActionImpl;
import cc.unilock.nilcord.lib.jda.internal.requests.restaction.WebhookMessageDeleteActionImpl;
import cc.unilock.nilcord.lib.jda.internal.requests.restaction.WebhookMessageEditActionImpl;
import cc.unilock.nilcord.lib.jda.internal.requests.restaction.WebhookMessageRetrieveActionImpl;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import java.util.function.Function;

public class IncomingWebhookClientImpl
extends AbstractWebhookClient<Message>
implements IncomingWebhookClient {
    public IncomingWebhookClientImpl(long webhookId, String webhookToken, JDA api) {
        super(webhookId, webhookToken, api);
    }

    @Override
    public WebhookMessageCreateActionImpl<Message> sendRequest() {
        Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK.compile(Long.toUnsignedString(this.id), this.token);
        route = route.withQueryParams("wait", "true");
        route = route.withQueryParams("with_components", "true");
        WebhookMessageCreateActionImpl<Message> action = new WebhookMessageCreateActionImpl<Message>(this.api, route, this.builder());
        action.run();
        action.setInteraction(false);
        return action;
    }

    @Override
    public WebhookMessageEditActionImpl<Message> editRequest(@Nonnull String messageId) {
        if (!"@original".equals(messageId)) {
            Checks.isSnowflake(messageId);
        }
        Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK_EDIT.compile(Long.toUnsignedString(this.id), this.token, messageId);
        route = route.withQueryParams("wait", "true");
        route = route.withQueryParams("with_components", "true");
        WebhookMessageEditActionImpl<Message> action = new WebhookMessageEditActionImpl<Message>(this.api, route, this.builder());
        action.run();
        return action;
    }

    @Override
    @Nonnull
    public WebhookMessageRetrieveAction retrieveMessageById(@Nonnull String messageId) {
        if (!"@original".equals(messageId)) {
            Checks.isSnowflake(messageId);
        }
        Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK_FETCH.compile(Long.toUnsignedString(this.id), this.token, messageId);
        WebhookMessageRetrieveActionImpl action = new WebhookMessageRetrieveActionImpl(this.api, route, (response, request) -> this.builder().apply(response.getObject()));
        action.run();
        return action;
    }

    @Override
    @Nonnull
    public WebhookMessageDeleteAction deleteMessageById(@Nonnull String messageId) {
        WebhookMessageDeleteActionImpl action = (WebhookMessageDeleteActionImpl)super.deleteMessageById(messageId);
        action.run();
        return action;
    }

    private Function<DataObject, Message> builder() {
        return data -> {
            JDAImpl jda = (JDAImpl)this.api;
            long channelId = data.getUnsignedLong("channel_id");
            MessageChannel channel = this.api.getChannelById(MessageChannel.class, channelId);
            EntityBuilder entityBuilder = jda.getEntityBuilder();
            ReceivedMessage message = entityBuilder.createMessageBestEffort((DataObject)data, channel, null);
            message.withHook(this);
            return message;
        };
    }
}

