/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.requests.restaction;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.Message;
import cc.unilock.nilcord.lib.jda.api.entities.WebhookClient;
import cc.unilock.nilcord.lib.jda.api.entities.channel.ChannelType;
import cc.unilock.nilcord.lib.jda.api.entities.channel.middleman.GuildChannel;
import cc.unilock.nilcord.lib.jda.api.entities.channel.middleman.MessageChannel;
import cc.unilock.nilcord.lib.jda.api.interactions.InteractionHook;
import cc.unilock.nilcord.lib.jda.api.requests.Request;
import cc.unilock.nilcord.lib.jda.api.requests.Response;
import cc.unilock.nilcord.lib.jda.api.requests.Route;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.MessageEditAction;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataObject;
import cc.unilock.nilcord.lib.jda.api.utils.messages.MessageEditBuilder;
import cc.unilock.nilcord.lib.jda.api.utils.messages.MessageEditData;
import cc.unilock.nilcord.lib.jda.internal.entities.EntityBuilder;
import cc.unilock.nilcord.lib.jda.internal.entities.ReceivedMessage;
import cc.unilock.nilcord.lib.jda.internal.requests.RestActionImpl;
import cc.unilock.nilcord.lib.jda.internal.utils.message.MessageEditBuilderMixin;
import cc.unilock.nilcord.lib.okhttp3.RequestBody;
import java.util.function.BooleanSupplier;

public class MessageEditActionImpl
extends RestActionImpl<Message>
implements MessageEditAction,
MessageEditBuilderMixin<MessageEditAction> {
    private final String messageId;
    private final Guild guild;
    private final MessageChannel channel;
    private final MessageEditBuilder builder = new MessageEditBuilder();
    private WebhookClient<Message> webhook;
    private String threadId;

    public MessageEditActionImpl(@Nonnull JDA jda, @Nullable Guild guild, @Nonnull String channelId, @Nonnull String messageId) {
        super(jda, Route.Messages.EDIT_MESSAGE.compile(channelId, messageId));
        this.channel = null;
        this.guild = guild;
        this.messageId = messageId;
    }

    public MessageEditActionImpl(@Nonnull MessageChannel channel, @Nonnull String messageId) {
        super(channel.getJDA(), Route.Messages.EDIT_MESSAGE.compile(channel.getId(), messageId));
        this.channel = channel;
        this.guild = channel instanceof GuildChannel ? ((GuildChannel)((Object)channel)).getGuild() : null;
        this.messageId = messageId;
    }

    public MessageEditActionImpl withHook(WebhookClient<Message> hook, ChannelType channelType, long channelId) {
        this.webhook = hook;
        if (!(hook instanceof InteractionHook) && channelType.isThread()) {
            this.threadId = Long.toUnsignedString(channelId);
        }
        return this;
    }

    @Override
    public MessageEditBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        if (!(this.webhook == null || this.webhook instanceof InteractionHook && ((InteractionHook)this.webhook).isExpired())) {
            Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK_EDIT.compile(this.webhook.getId(), this.webhook.getToken(), this.messageId);
            if (this.threadId != null) {
                route = route.withQueryParams("thread_id", this.threadId);
            }
            return route;
        }
        return super.finalizeRoute();
    }

    @Override
    protected RequestBody finalizeData() {
        try (MessageEditData data = this.builder.build();){
            RequestBody requestBody = this.getMultipartBody(data.getFiles(), data.toData());
            return requestBody;
        }
    }

    @Override
    protected void handleSuccess(Response response, Request<Message> request) {
        EntityBuilder entityBuilder = this.api.getEntityBuilder();
        DataObject json = response.getObject();
        ReceivedMessage message = entityBuilder.createMessageBestEffort(json, this.channel, this.guild);
        request.onSuccess(message.withHook(this.webhook));
    }

    @Override
    @Nonnull
    public MessageEditAction setCheck(BooleanSupplier checks) {
        return (MessageEditAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public MessageEditAction deadline(long timestamp) {
        return (MessageEditAction)super.deadline(timestamp);
    }
}

