/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.requests.restaction.interactions;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.entities.Message;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.interactions.InteractionCallbackAction;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataObject;
import cc.unilock.nilcord.lib.jda.api.utils.messages.MessageCreateBuilder;
import cc.unilock.nilcord.lib.jda.api.utils.messages.MessageCreateData;
import cc.unilock.nilcord.lib.jda.internal.interactions.InteractionHookImpl;
import cc.unilock.nilcord.lib.jda.internal.requests.restaction.interactions.DeferrableCallbackActionImpl;
import cc.unilock.nilcord.lib.jda.internal.utils.message.MessageCreateBuilderMixin;
import cc.unilock.nilcord.lib.okhttp3.RequestBody;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;

public class ReplyCallbackActionImpl
extends DeferrableCallbackActionImpl
implements ReplyCallbackAction,
MessageCreateBuilderMixin<ReplyCallbackAction> {
    private final MessageCreateBuilder builder = new MessageCreateBuilder();
    private int flags;

    public ReplyCallbackActionImpl(InteractionHookImpl hook) {
        super(hook);
    }

    @Override
    public MessageCreateBuilder getBuilder() {
        return this.builder;
    }

    @Override
    @Nonnull
    public ReplyCallbackActionImpl closeResources() {
        this.builder.closeFiles();
        return this;
    }

    @Override
    @Nonnull
    protected RequestBody finalizeData() {
        DataObject json = DataObject.empty();
        if (this.builder.isEmpty()) {
            json.put("type", InteractionCallbackAction.ResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE.getRaw());
            if (this.flags != 0) {
                json.put("data", DataObject.empty().put("flags", this.flags));
            }
            return this.getRequestBody(json);
        }
        json.put("type", InteractionCallbackAction.ResponseType.CHANNEL_MESSAGE_WITH_SOURCE.getRaw());
        try (MessageCreateData data = this.builder.build();){
            DataObject msg = data.toData();
            msg.put("flags", msg.getInt("flags", 0) | this.flags);
            json.put("data", msg);
            RequestBody requestBody = this.getMultipartBody(data.getFiles(), json);
            return requestBody;
        }
    }

    @Override
    @Nonnull
    public ReplyCallbackActionImpl setEphemeral(boolean ephemeral) {
        int flag = Message.MessageFlag.EPHEMERAL.getValue();
        this.flags = ephemeral ? (this.flags |= flag) : (this.flags &= ~flag);
        return this;
    }

    @Override
    @Nonnull
    public ReplyCallbackAction setCheck(BooleanSupplier checks) {
        return (ReplyCallbackAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public ReplyCallbackAction timeout(long timeout2, @Nonnull TimeUnit unit) {
        return (ReplyCallbackAction)super.timeout(timeout2, unit);
    }

    @Override
    @Nonnull
    public ReplyCallbackAction deadline(long timestamp) {
        return (ReplyCallbackAction)super.deadline(timestamp);
    }
}

