/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.requests.restaction.order;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.Permission;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.Member;
import cc.unilock.nilcord.lib.jda.api.entities.channel.attribute.ICategorizableChannel;
import cc.unilock.nilcord.lib.jda.api.entities.channel.concrete.Category;
import cc.unilock.nilcord.lib.jda.api.entities.channel.middleman.GuildChannel;
import cc.unilock.nilcord.lib.jda.api.exceptions.InsufficientPermissionException;
import cc.unilock.nilcord.lib.jda.api.requests.Route;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.order.ChannelOrderAction;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataArray;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataObject;
import cc.unilock.nilcord.lib.jda.internal.requests.restaction.order.OrderActionImpl;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import cc.unilock.nilcord.lib.okhttp3.RequestBody;
import cc.unilock.nilcord.lib.trove.map.TLongLongMap;
import cc.unilock.nilcord.lib.trove.map.hash.TLongLongHashMap;
import cc.unilock.nilcord.lib.trove.set.TLongSet;
import cc.unilock.nilcord.lib.trove.set.hash.TLongHashSet;
import java.util.Collection;
import java.util.stream.Collectors;

public class ChannelOrderActionImpl
extends OrderActionImpl<GuildChannel, ChannelOrderAction>
implements ChannelOrderAction {
    protected final Guild guild;
    protected final int bucket;
    protected final TLongSet lockPermissions = new TLongHashSet();
    protected final TLongLongMap parent = new TLongLongHashMap();

    public ChannelOrderActionImpl(Guild guild, int bucket) {
        this(guild, bucket, ChannelOrderActionImpl.getChannelsOfType(guild, bucket));
    }

    public ChannelOrderActionImpl(Guild guild, int bucket, Collection<? extends GuildChannel> channels) {
        super(guild.getJDA(), Route.Guilds.MODIFY_CHANNELS.compile(guild.getId()));
        Checks.notNull(channels, "Channels to order");
        Checks.notEmpty(channels, "Channels to order");
        Checks.check(channels.stream().allMatch(c -> guild.equals(c.getGuild())), "One or more channels are not from the correct guild");
        Checks.check(channels.stream().allMatch(c -> c.getType().getSortBucket() == bucket), "One or more channels did not match the expected bucket " + bucket);
        this.guild = guild;
        this.bucket = bucket;
        this.orderList.addAll(channels);
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public int getSortBucket() {
        return this.bucket;
    }

    @Override
    @Nonnull
    public ChannelOrderAction setCategory(@Nullable Category category, boolean syncPermissions) {
        GuildChannel channel = (GuildChannel)this.getSelectedEntity();
        if (!(channel instanceof ICategorizableChannel) && category != null) {
            throw new IllegalStateException("Cannot move channel of type " + (Object)((Object)channel.getType()) + " to category!");
        }
        if (category != null) {
            Checks.check(category.getGuild().equals(this.getGuild()), "Category is not from the same guild!");
        }
        long id = channel.getIdLong();
        this.parent.put(id, category == null ? 0L : category.getIdLong());
        if (syncPermissions) {
            this.lockPermissions.add(id);
        } else {
            this.lockPermissions.remove(id);
        }
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        Member self = this.guild.getSelfMember();
        if (!self.hasPermission(Permission.MANAGE_CHANNEL)) {
            throw new InsufficientPermissionException(this.guild, Permission.MANAGE_CHANNEL);
        }
        DataArray array = DataArray.empty();
        for (int i = 0; i < this.orderList.size(); ++i) {
            GuildChannel chan = (GuildChannel)this.orderList.get(i);
            DataObject json = DataObject.empty().put("id", chan.getId()).put("position", i);
            if (this.parent.containsKey(chan.getIdLong())) {
                long parentId = this.parent.get(chan.getIdLong());
                json.put("parent_id", parentId == 0L ? null : Long.valueOf(parentId));
                json.put("lock_permissions", this.lockPermissions.contains(chan.getIdLong()));
            }
            array.add(json);
        }
        return this.getRequestBody(array);
    }

    @Override
    protected void validateInput(GuildChannel entity) {
        Checks.check(entity.getGuild().equals(this.guild), "Provided channel is not from this Guild!");
        Checks.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }

    protected static Collection<GuildChannel> getChannelsOfType(Guild guild, int bucket) {
        return guild.getChannels().stream().filter(it -> it.getType().getSortBucket() == bucket).sorted().collect(Collectors.toList());
    }
}

