/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.utils.localization;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.interactions.DiscordLocale;
import cc.unilock.nilcord.lib.jda.api.interactions.commands.localization.LocalizationMap;
import cc.unilock.nilcord.lib.jda.api.utils.data.DataObject;
import cc.unilock.nilcord.lib.jda.internal.interactions.command.localization.UnmodifiableLocalizationMap;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import cc.unilock.nilcord.lib.jda.internal.utils.JDALogger;
import cc.unilock.nilcord.lib.slf4j.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LocalizationUtils {
    public static final Logger LOG = JDALogger.getLog(LocalizationUtils.class);

    @Nonnull
    public static Map<DiscordLocale, String> mapFromData(@Nonnull DataObject data) {
        Checks.notNull(data, "Data");
        HashMap<DiscordLocale, String> map = new HashMap<DiscordLocale, String>();
        for (String key : data.keys()) {
            DiscordLocale locale = DiscordLocale.from(key);
            if (locale == DiscordLocale.UNKNOWN) {
                LOG.debug("Discord provided an unknown locale, locale tag: {}", (Object)key);
                continue;
            }
            map.put(locale, data.getString(key));
        }
        return map;
    }

    @Nonnull
    public static Map<DiscordLocale, String> mapFromProperty(@Nonnull DataObject json, @Nonnull String localizationProperty) {
        return json.optObject(localizationProperty).map(LocalizationUtils::mapFromData).orElse(Collections.emptyMap());
    }

    @Nonnull
    public static LocalizationMap unmodifiableFromProperty(@Nonnull DataObject json, @Nonnull String localizationProperty) {
        return new UnmodifiableLocalizationMap(LocalizationUtils.mapFromProperty(json, localizationProperty));
    }
}

