/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api;

import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.values.CompoundConfigValue;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;

public interface Constraint<T> {
    public Optional<String> test(T var1);

    public String getRepresentation();

    public static Constraint<Integer> range(int from, int to) {
        return new Range<Integer>(from, to, Integer::compareTo);
    }

    public static Constraint<Long> range(long from, long to) {
        return new Range<Long>(from, to, Long::compareTo);
    }

    public static Constraint<Float> range(float from, float to) {
        return new Range<Float>(Float.valueOf(from), Float.valueOf(to), Float::compareTo);
    }

    public static Constraint<Double> range(double from, double to) {
        return new Range<Double>(from, to, Double::compareTo);
    }

    public static <T> Constraint<CompoundConfigValue<T>> all(Constraint<T> constraint) {
        return new All<T>(constraint);
    }

    public static Constraint<String> matching(final String regex) {
        return new Constraint<String>(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(regex);
            }

            @Override
            public Optional<String> test(String value) {
                if (this.pattern.matcher(value).matches()) {
                    return Optional.empty();
                }
                return Optional.of(String.format("Value '%s' does not match pattern '%s'", value, regex));
            }

            @Override
            public String getRepresentation() {
                return "matches r'" + regex + "'";
            }
        };
    }

    public static final class Range<T>
    implements Constraint<T> {
        private final T min;
        private final T max;
        private final Comparator<T> comparator;

        public Range(T min, T max, Comparator<T> comparator) {
            this.min = min;
            this.max = max;
            this.comparator = comparator;
        }

        public T min() {
            return this.min;
        }

        public T max() {
            return this.max;
        }

        @Override
        public Optional<String> test(T value) {
            int minTest = this.comparator.compare(this.min, value);
            int maxTest = this.comparator.compare(this.max, value);
            if (minTest <= 0 && maxTest >= 0) {
                return Optional.empty();
            }
            return Optional.of(String.format("Value '%s' outside of range [%s, %s]", value, this.min, this.max));
        }

        @Override
        public String getRepresentation() {
            return "range: " + this.min + " - " + this.max;
        }
    }

    public static final class All<T>
    implements Constraint<CompoundConfigValue<T>> {
        private final Constraint<T> constraint;

        public All(Constraint<T> constraint) {
            this.constraint = constraint;
        }

        @Override
        public Optional<String> test(CompoundConfigValue<T> value) {
            StringBuilder builder = new StringBuilder();
            for (T t : value.values()) {
                Optional<String> error = this.constraint.test(t);
                if (!error.isPresent()) continue;
                if (builder.length() != 0) {
                    builder.append(", ");
                }
                builder.append(error.get());
            }
            return builder.length() == 0 ? Optional.empty() : Optional.of(builder.toString());
        }

        @Override
        public String getRepresentation() {
            return "all(" + this.constraint.getRepresentation() + ")";
        }
    }
}

