/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.impl.util;

import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.annotations.DisplayNameConvention;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.annotations.SerializedNameConvention;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.metadata.NamingScheme;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public final class NamingSchemeHelper {
    private final ClassLoader classLoader;
    private final Map<String, NamingScheme> customSchemeCache;

    public NamingSchemeHelper(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.customSchemeCache = new HashMap<String, NamingScheme>();
    }

    public NamingSchemeHelper() {
        this(NamingSchemeHelper.class.getClassLoader());
    }

    public NamingScheme getNamingScheme(SerializedNameConvention annotation, BiFunction<String, Throwable, RuntimeException> exceptionFactory) {
        if (annotation.custom().isEmpty()) {
            return annotation.value();
        }
        return this.createCustomNamingScheme(annotation.custom(), exceptionFactory);
    }

    public NamingScheme getNamingScheme(DisplayNameConvention annotation, BiFunction<String, Throwable, RuntimeException> exceptionFactory) {
        if (annotation.custom().isEmpty()) {
            return annotation.value();
        }
        return this.createCustomNamingScheme(annotation.custom(), exceptionFactory);
    }

    private NamingScheme createCustomNamingScheme(String className, BiFunction<String, Throwable, RuntimeException> exceptionFactory) {
        return this.customSchemeCache.computeIfAbsent(className, customSchemeName -> {
            NamingScheme customScheme;
            try {
                Class<?> customSchemeClass = Class.forName(customSchemeName, true, this.classLoader);
                customScheme = (NamingScheme)customSchemeClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw (RuntimeException)exceptionFactory.apply("Couldn't find custom naming scheme class '" + customSchemeName + "'", e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw (RuntimeException)exceptionFactory.apply("Couldn't create instance of custom name scheme class '" + customSchemeName + "'", e);
            }
            catch (ClassCastException e) {
                throw (RuntimeException)exceptionFactory.apply("Class '" + customSchemeName + "' does not implement '" + NamingScheme.class.getName() + "'", e);
            }
            return customScheme;
        });
    }
}

