/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.impl.util;

import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.Config;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.annotations.Alias;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.annotations.SerializedName;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.annotations.SerializedNameConvention;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.values.CompoundConfigValue;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.values.ValueKey;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.api.values.ValueTreeNode;
import cc.unilock.nilcord.lib.kaleido.lib.quiltconfig.impl.values.ValueKeyImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SerializerUtils {
    public static Optional<String> getDefaultValueString(Object defaultValue) {
        try {
            if (defaultValue.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class && !(defaultValue instanceof CompoundConfigValue)) {
                return Optional.of(defaultValue.toString());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static Optional<String> createEnumOptionsComment(Object defaultValue) {
        if (defaultValue.getClass().isEnum()) {
            StringBuilder options = new StringBuilder("options: ");
            ?[] enumConstants = defaultValue.getClass().getEnumConstants();
            int enumConstantsLength = enumConstants.length;
            for (int i = 0; i < enumConstantsLength; ++i) {
                Object o = enumConstants[i];
                options.append(o);
                if (i >= enumConstantsLength - 1) continue;
                options.append(", ");
            }
            return Optional.of(options.toString());
        }
        return Optional.empty();
    }

    public static List<ValueKey> getPossibleKeys(Config config, ValueTreeNode value) {
        ArrayList<ValueKey> possibleKeys = new ArrayList<ValueKey>();
        possibleKeys.add(SerializerUtils.getSerializedKey(config, value));
        if (value.hasMetadata(Alias.TYPE)) {
            for (String alias : value.metadata(Alias.TYPE)) {
                ArrayList<String> aliasKey = new ArrayList<String>();
                for (int i = 0; i < value.key().length(); ++i) {
                    if (i != value.key().length() - 1) {
                        aliasKey.add(value.key().getKeyComponent(i));
                        continue;
                    }
                    aliasKey.add(alias);
                }
                possibleKeys.add(new ValueKeyImpl(aliasKey.toArray(new String[0])));
            }
        }
        return possibleKeys;
    }

    public static ValueKey getSerializedKey(Config config, ValueTreeNode value) {
        ArrayList<String> serializedKey = new ArrayList<String>();
        ValueKey key = value.key();
        ArrayList<String> rawKey = new ArrayList<String>();
        for (int i = 0; i < value.key().length(); ++i) {
            rawKey.add(key.getKeyComponent(i));
            ValueTreeNode currentNode = config.getNode(rawKey);
            serializedKey.add(SerializerUtils.getSerializedName(currentNode));
        }
        return new ValueKeyImpl(serializedKey.toArray(new String[0]));
    }

    public static String getSerializedName(ValueTreeNode value) {
        if (value.hasMetadata(SerializedName.TYPE)) {
            return value.metadata(SerializedName.TYPE).getName();
        }
        if (value.hasMetadata(SerializedNameConvention.TYPE)) {
            return value.metadata(SerializedNameConvention.TYPE).coerce(value.key().getLastComponent());
        }
        return value.key().getLastComponent();
    }
}

