/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.util;

import cc.unilock.nilcord.util.ColorUtils;
import cc.unilock.nilcord.util.SkinUtils;
import com.google.common.base.CharMatcher;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.placeholders.api.parsers.MarkdownLiteParserV1;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class TextUtils {
    private static final Pattern ANGLE_BRACKETS = Pattern.compile("(?<!((?<!(\\\\))\\\\))<(?<id>[^<>]+)>");

    private static class_2561 parse(String str) {
        return TextParserUtils.formatText((String)str);
    }

    public static class_2561 parseDiscordMessage(String template, String attachmentChunk, class_2561 replyChunk, String usernameChunk, User author, Member member, Message message) {
        template = template.replace("<attachment_format>", attachmentChunk).replace("<username_format>", usernameChunk).replace("<role_color>", member == null ? ColorUtils.WHITE : ColorUtils.getHexColor(member)).replace("<message_url>", message.getJumpUrl());
        Map<String, class_2561> placeholders = Map.of("reply_format", replyChunk, "username", class_2561.method_43470((String)author.getName()), "nickname", class_2561.method_43470((String)(member == null ? author.getEffectiveName() : member.getEffectiveName())), "message", MarkdownLiteParserV1.ALL.parseText(message.getContentDisplay(), ParserContext.of()));
        return Placeholders.parseText((class_2561)TextUtils.parse(template), (Pattern)ANGLE_BRACKETS, placeholders);
    }

    public static class_2561 parseDiscordReply(String template, Message refMessage) {
        User refAuthor = refMessage.getAuthor();
        Member refMember = refMessage.getMember();
        template = template.replace("<reply_role_color>", refMember == null ? ColorUtils.WHITE : ColorUtils.getHexColor(refMember)).replace("<reply_url>", refMessage.getJumpUrl());
        Map<String, class_2561> placeholders = Map.of("reply_username", class_2561.method_43470((String)refAuthor.getName()), "reply_nickname", class_2561.method_43470((String)(refMember == null ? refAuthor.getEffectiveName() : refMember.getEffectiveName())), "reply_message", MarkdownLiteParserV1.ALL.parseText(refMessage.getContentDisplay(), ParserContext.of()));
        return Placeholders.parseText((class_2561)TextUtils.parse(template), (Pattern)ANGLE_BRACKETS, placeholders);
    }

    public static class_2561 parsePlayer(String template, class_3222 player) {
        Map<String, class_5250> placeholders = Map.of("displayname", (class_2561)Objects.requireNonNullElse(player.method_5476(), class_2561.method_43470((String)player.method_7334().getName())), "username", class_2561.method_43470((String)player.method_7334().getName()));
        return Placeholders.parseText((class_2561)Placeholders.parseText((class_2561)TextUtils.parse(template), (Pattern)ANGLE_BRACKETS, placeholders), (PlaceholderContext)PlaceholderContext.of((class_3222)player));
    }

    public static class_2561 parseAvatar(String template, class_3222 player) {
        SkinUtils.Skin skin = SkinUtils.getSkin(player.method_7334());
        Map<String, class_5250> placeholders = Map.of("skin_id", class_2561.method_43470((String)skin.id()), "skin_model", class_2561.method_43470((String)skin.model()), "uuid", class_2561.method_43470((String)player.method_7334().getId().toString()));
        return Placeholders.parseText((class_2561)TextUtils.parsePlayer(template, player), (Pattern)ANGLE_BRACKETS, placeholders);
    }

    public static class_2561 parseMessage(String template, class_3222 player, class_2561 message) {
        class_5250 unspoiled = class_5250.method_43477((class_7417)class_8828.field_46625);
        message.method_27658((style, literal) -> {
            class_2561 hoverText;
            class_2568 hover;
            if (CharMatcher.is((char)literal.charAt(0)).matchesAllOf((CharSequence)literal.substring(1)) && (hover = style.method_10969()) != null && class_2568.class_5247.field_24342.equals(hover.method_10892()) && (hoverText = (class_2561)hover.method_10891(class_2568.class_5247.field_24342)) != null) {
                unspoiled.method_27693("||" + hoverText.getString() + "||");
                return Optional.empty();
            }
            unspoiled.method_27693(literal);
            return Optional.empty();
        }, class_2583.field_24360);
        Map<String, class_5250> placeholders = Map.of("message", unspoiled);
        return Placeholders.parseText((class_2561)TextUtils.parsePlayer(template, player), (Pattern)ANGLE_BRACKETS, placeholders);
    }

    public static class_2561 parseAdvancement(String template, class_3222 player, class_185 display) {
        Map<String, class_2561> placeholders = Map.of("advancement_title", display.method_811(), "advancement_description", display.method_817());
        return Placeholders.parseText((class_2561)TextUtils.parsePlayer(template, player), (Pattern)ANGLE_BRACKETS, placeholders);
    }

    public static class_2561 parseDeath(String template, class_3222 player, class_1282 source) {
        Map<String, class_2561> placeholders = Map.of("death_message", source.method_5506((class_1309)player));
        return Placeholders.parseText((class_2561)TextUtils.parsePlayer(template, player), (Pattern)ANGLE_BRACKETS, placeholders);
    }
}

