/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.discord;

import cc.unilock.nilcord.NilcordPremain;
import cc.unilock.nilcord.util.TextUtils;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueList;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.IncomingWebhookClient;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.WebhookClient;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Discord
extends ListenerAdapter {
    private static final Pattern WEBHOOK_ID_REGEX = Pattern.compile("^https://discord\\.com/api/webhooks/(\\d+)/.+$");
    private final JDA jda;
    private final IncomingWebhookClient webhook;
    private final String webhookId;
    private boolean shutdown = false;
    private static final Pattern EVERYONE_AND_HERE_PATTERN = Pattern.compile("@(?<ping>everyone|here)");

    public Discord() {
        JDABuilder builder = JDABuilder.createDefault((String)((String)NilcordPremain.CONFIG.discord.token.value())).addEventListeners(new Object[]{this}).setChunkingFilter(ChunkingFilter.ALL).setMemberCachePolicy(MemberCachePolicy.ALL).enableIntents(GatewayIntent.GUILD_MEMBERS, new GatewayIntent[]{GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT});
        try {
            this.jda = builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to log into Discord!", e);
        }
        if (((Boolean)NilcordPremain.CONFIG.discord.webhook.enabled.value()).booleanValue()) {
            try {
                this.webhook = WebhookClient.createClient((JDA)this.jda, (String)((String)NilcordPremain.CONFIG.discord.webhook.url.value()));
                Matcher matcher = WEBHOOK_ID_REGEX.matcher((CharSequence)NilcordPremain.CONFIG.discord.webhook.url.value());
                this.webhookId = matcher.find() ? matcher.group(1) : null;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Invalid webhook URL!");
            }
        } else {
            this.webhook = null;
            this.webhookId = null;
        }
    }

    public void onReady(@NotNull ReadyEvent event) {
        NilcordPremain.LOGGER.info("Bot ready!");
    }

    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        if (NilcordPremain.server == null) {
            return;
        }
        if (((String)NilcordPremain.CONFIG.formatting.minecraft.discord_message.value()).isBlank()) {
            return;
        }
        if (!event.isFromType(ChannelType.TEXT)) {
            return;
        }
        if (!event.getChannel().asTextChannel().getId().equals(NilcordPremain.CONFIG.discord.channel_id.value())) {
            return;
        }
        if (!((Boolean)NilcordPremain.CONFIG.minecraft.show_webhook_messages.value()).booleanValue() && event.isWebhookMessage()) {
            return;
        }
        User author = event.getAuthor();
        if (!((Boolean)NilcordPremain.CONFIG.minecraft.show_bot_messages.value()).booleanValue() && author.isBot()) {
            return;
        }
        if (((ValueList)NilcordPremain.CONFIG.minecraft.ignored_ids.value()).contains((Object)author.getId())) {
            return;
        }
        if (author.getId().equals(this.jda.getSelfUser().getId()) || author.getId().equals(this.webhookId)) {
            return;
        }
        Message message = event.getMessage();
        MessageReference ref = message.getMessageReference();
        Member member = message.getMember();
        StringBuilder attachment_chunk = new StringBuilder(message.getContentDisplay().isEmpty() ? "" : " ");
        if (((Boolean)NilcordPremain.CONFIG.minecraft.show_attachments.value()).booleanValue()) {
            for (Message.Attachment attachment : message.getAttachments()) {
                attachment_chunk.append(((String)NilcordPremain.CONFIG.formatting.minecraft.attachment_format.value()).replace("<attachment_url>", attachment.getUrl()));
            }
        }
        class_5250 reply_chunk = class_2561.method_43473();
        if (ref != null) {
            reply_chunk = TextUtils.parseDiscordReply((String)NilcordPremain.CONFIG.formatting.minecraft.reply_format.value(), ref.getMessage() == null ? (Message)ref.resolve().complete() : ref.getMessage());
        }
        class_2561 msg = TextUtils.parseDiscordMessage((String)NilcordPremain.CONFIG.formatting.minecraft.discord_message.value(), attachment_chunk.toString(), (class_2561)reply_chunk, (String)NilcordPremain.CONFIG.formatting.minecraft.username_format.value(), author, member, message);
        NilcordPremain.server.method_3760().method_43514(msg, false);
    }

    public void onPlayerChatMessage(class_3222 player, class_2561 message) {
        String msg = TextUtils.parseMessage((Boolean)NilcordPremain.CONFIG.discord.webhook.enabled.value() != false ? (String)NilcordPremain.CONFIG.formatting.discord.webhook.chat_message.value() : (String)NilcordPremain.CONFIG.formatting.discord.chat_message.value(), player, message).getString();
        if (!((Boolean)NilcordPremain.CONFIG.minecraft.enable_everyone_and_here.value()).booleanValue()) {
            msg = this.parseEveryoneAndHere(msg);
        }
        if (((Boolean)NilcordPremain.CONFIG.minecraft.enable_mentions.value()).booleanValue()) {
            msg = this.parseMentions(msg);
        }
        this.sendMessageToDiscord(msg, player);
    }

    public void sendMessageToDiscord(String message) {
        this.sendMessageToDiscord(message, null);
    }

    public void sendMessageToDiscord(String message, @Nullable class_3222 player) {
        if (!((Boolean)NilcordPremain.CONFIG.discord.webhook.enabled.value()).booleanValue() || this.webhook == null || player == null) {
            this.sendBotMessageToDiscord(message);
        } else {
            this.sendWebhookMessageToDiscord(message, player);
        }
    }

    public void sendBotMessageToDiscord(String message) {
        TextChannel textChannel = this.jda.getTextChannelById((String)NilcordPremain.CONFIG.discord.channel_id.value());
        if (textChannel != null) {
            textChannel.sendMessage((CharSequence)message).queue();
        } else {
            NilcordPremain.LOGGER.error("Unable to find channel {}!", NilcordPremain.CONFIG.discord.channel_id.value());
        }
    }

    public void sendWebhookMessageToDiscord(String message, class_3222 player) {
        String avatar = TextUtils.parseAvatar((String)NilcordPremain.CONFIG.formatting.discord.webhook.avatar_url.value(), player).getString();
        String username = TextUtils.parsePlayer((String)NilcordPremain.CONFIG.formatting.discord.webhook.username.value(), player).getString();
        try (MessageCreateData data = ((MessageCreateBuilder)new MessageCreateBuilder().setContent(message)).build();){
            this.webhook.sendMessage(data).setAvatarUrl(avatar).setUsername(username).queue();
        }
    }

    private String parseEveryoneAndHere(String message) {
        return EVERYONE_AND_HERE_PATTERN.matcher(message).replaceAll("@\u200b${ping}");
    }

    private String parseMentions(String message) {
        String msg = message;
        TextChannel textChannel = this.jda.getTextChannelById((String)NilcordPremain.CONFIG.discord.channel_id.value());
        if (textChannel != null) {
            for (Member member : textChannel.getMembers()) {
                message = Pattern.compile(Pattern.quote("@" + member.getUser().getName()), 2).matcher(msg).replaceAll(member.getAsMention());
            }
        }
        return message;
    }

    public void startJda() {
        try {
            this.jda.awaitReady();
        }
        catch (InterruptedException e) {
            NilcordPremain.LOGGER.error(e.toString());
        }
    }

    public void stopJda() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        try {
            this.jda.removeEventListener(new Object[]{this});
            this.jda.shutdown();
            if (!this.jda.awaitShutdown(Duration.ofSeconds(3L))) {
                NilcordPremain.LOGGER.error("JDA shutdown timeout exceeded! Shutting down now...");
                this.jda.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            NilcordPremain.LOGGER.error(e.toString());
        }
    }
}

