/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.util;

import cc.unilock.nilcord.util.ColorUtils;
import cc.unilock.nilcord.util.SkinUtils;
import com.google.common.base.CharMatcher;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.MarkdownLiteParserV1;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.ParserBuilder;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class TextUtils {
    private static final NodeParser PARSER = ParserBuilder.of().globalPlaceholders().markdown().quickText().simplifiedTextFormat().build();

    public static class_2561 parseDiscordMessage(String template, String attachmentChunk, class_2561 replyChunk, String usernameChunk, User author, Member member, Message message) {
        template = template.replace("<attachment_format>", attachmentChunk).replace("<username_format>", usernameChunk).replace("<role_color>", member == null ? ColorUtils.WHITE : ColorUtils.getHexColor(member)).replace("<message_url>", message.getJumpUrl());
        Function<String, class_2561> placeholders = str -> switch (str) {
            case "reply_format" -> replyChunk;
            case "username" -> class_2561.method_43470((String)author.getName());
            case "nickname" -> class_2561.method_43470((String)(member == null ? author.getEffectiveName() : member.getEffectiveName()));
            case "message" -> MarkdownLiteParserV1.ALL.parseText(message.getContentDisplay(), ParserContext.of());
            default -> null;
        };
        return TagLikeParser.placeholderText((TagLikeParser.Format)TagLikeParser.TAGS, placeholders).parseText(PARSER.parseNode(template), ParserContext.of());
    }

    public static class_2561 parseDiscordReply(String template, Message refMessage) {
        User refAuthor = refMessage.getAuthor();
        Member refMember = refMessage.getMember();
        template = template.replace("<reply_role_color>", refMember == null ? ColorUtils.WHITE : ColorUtils.getHexColor(refMember)).replace("<reply_url>", refMessage.getJumpUrl());
        Function<String, class_2561> placeholders = str -> switch (str) {
            case "reply_username" -> class_2561.method_43470((String)refAuthor.getName());
            case "reply_nickname" -> class_2561.method_43470((String)(refMember == null ? refAuthor.getEffectiveName() : refMember.getEffectiveName()));
            case "reply_message" -> MarkdownLiteParserV1.ALL.parseText(refMessage.getContentDisplay(), ParserContext.of());
            default -> null;
        };
        return TagLikeParser.placeholderText((TagLikeParser.Format)TagLikeParser.TAGS, placeholders).parseText(PARSER.parseNode(template), ParserContext.of());
    }

    public static class_2561 parsePlayer(String template, class_3222 player) {
        Function<String, class_2561> placeholders = str -> switch (str) {
            case "displayname" -> (class_2561)Objects.requireNonNullElse(player.method_5476(), class_2561.method_43470((String)player.method_7334().name()));
            case "username" -> class_2561.method_43470((String)player.method_7334().name());
            case "uuid" -> class_2561.method_43470((String)player.method_7334().id().toString());
            default -> null;
        };
        return TagLikeParser.placeholderText((TagLikeParser.Format)TagLikeParser.TAGS, placeholders).parseText(PARSER.parseNode(template), PlaceholderContext.of((class_3222)player).asParserContext());
    }

    public static class_2561 parseAvatar(String template, class_3222 player) {
        SkinUtils.Skin skin = SkinUtils.getSkin(player.method_7334());
        Function<String, class_2561> placeholders = str -> switch (str) {
            case "skin_id" -> class_2561.method_43470((String)skin.id());
            case "skin_model" -> class_2561.method_43470((String)skin.model());
            case "uuid" -> class_2561.method_43470((String)player.method_7334().id().toString());
            default -> null;
        };
        return TagLikeParser.placeholderText((TagLikeParser.Format)TagLikeParser.TAGS, placeholders).parseText(TextNode.convert((class_2561)TextUtils.parsePlayer(template, player)), ParserContext.of());
    }

    public static class_2561 parseMessage(String template, class_3222 player, class_2561 message) {
        class_5250 unspoiled = class_5250.method_43477((class_7417)class_8828.field_46625);
        message.method_27658((style, literal) -> {
            block3: {
                class_2568 patt1$temp;
                if (CharMatcher.is((char)literal.charAt(0)).matchesAllOf((CharSequence)literal.substring(1)) && (patt1$temp = style.method_10969()) instanceof class_2568.class_10613) {
                    class_2561 hoverText;
                    class_2568.class_10613 $b$0 = (class_2568.class_10613)patt1$temp;
                    try {
                        class_2561 patt2$temp;
                        hoverText = patt2$temp = $b$0.comp_3510();
                        if (hoverText == null) break block3;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    unspoiled.method_27693("||" + hoverText.getString() + "||");
                    return Optional.empty();
                }
            }
            unspoiled.method_27693(literal);
            return Optional.empty();
        }, class_2583.field_24360);
        Function<String, class_2561> placeholders = str -> switch (str) {
            case "message" -> unspoiled;
            default -> null;
        };
        return TagLikeParser.placeholderText((TagLikeParser.Format)TagLikeParser.TAGS, placeholders).parseText(TextNode.convert((class_2561)TextUtils.parsePlayer(template, player)), ParserContext.of());
    }

    public static class_2561 parseAdvancement(String template, class_3222 player, class_185 display) {
        Function<String, class_2561> placeholders = str -> switch (str) {
            case "advancement_title" -> display.method_811();
            case "advancement_description" -> display.method_817();
            default -> null;
        };
        return TagLikeParser.placeholderText((TagLikeParser.Format)TagLikeParser.TAGS, placeholders).parseText(TextNode.convert((class_2561)TextUtils.parsePlayer(template, player)), ParserContext.of());
    }

    public static class_2561 parseDeath(String template, class_3222 player, class_1282 source) {
        Function<String, class_2561> placeholders = str -> switch (str) {
            case "death_message" -> source.method_5506((class_1309)player);
            default -> null;
        };
        return TagLikeParser.placeholderText((TagLikeParser.Format)TagLikeParser.TAGS, placeholders).parseText(TextNode.convert((class_2561)TextUtils.parsePlayer(template, player)), ParserContext.of());
    }
}

