/*
 * Decompiled with CFR 0.152.
 */
package com.jamsackman.researchtableenchantments.mixin;

import com.jamsackman.researchtableenchantments.mixin.TargetPredicateAccessor;
import com.jamsackman.researchtableenchantments.registry.ModEnchantments;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1391;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_4051;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1391.class})
public abstract class TemptGoalMixin {
    @Shadow
    private class_1314 field_6616;
    @Shadow
    @Nullable
    private class_1657 field_6617;
    @Shadow
    private class_4051 field_28404;

    @Shadow
    protected abstract boolean method_6312(class_1309 var1);

    @Redirect(method={"canStart"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getClosestPlayer(Lnet/minecraft/entity/ai/TargetPredicate;Lnet/minecraft/entity/LivingEntity;)Lnet/minecraft/entity/player/PlayerEntity;"))
    private class_1657 researchtableenchantments$extendAromaticRange(class_1937 world, class_4051 targetPredicate, class_1309 entity) {
        class_1657 vanilla = world.method_18462(targetPredicate, entity);
        class_1657 aromatic = this.researchtableenchantments$findAromaticPlayer(world, entity, targetPredicate);
        if (aromatic == null) {
            return vanilla;
        }
        if (vanilla == null) {
            return aromatic;
        }
        double vanillaDistance = vanilla.method_5858((class_1297)entity);
        double aromaticDistance = aromatic.method_5858((class_1297)entity);
        return aromaticDistance < vanillaDistance ? aromatic : vanilla;
    }

    @Inject(method={"shouldContinue"}, at={@At(value="RETURN")}, cancellable=true)
    private void researchtableenchantments$extendContinuation(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        class_1657 player = this.field_6617;
        if (player == null || !player.method_5805()) {
            return;
        }
        int level = this.researchtableenchantments$getAromaticLevel(player);
        if (level <= 0) {
            return;
        }
        double baseRange = this.researchtableenchantments$getBaseRange();
        double maxRange = baseRange + (double)level * 3.0;
        if (player.method_5858((class_1297)this.field_6616) <= maxRange * maxRange && this.method_6312((class_1309)player)) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyArg(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/pathing/EntityNavigation;startMovingTo(Lnet/minecraft/entity/Entity;D)Z"), index=1)
    private double researchtableenchantments$boostTemptSpeed(double speed) {
        class_1657 player = this.field_6617;
        int level = this.researchtableenchantments$getAromaticLevel(player);
        if (level <= 0) {
            return speed;
        }
        return speed * (1.0 + (double)level * 0.15);
    }

    @Inject(method={"isTemptedBy"}, at={@At(value="RETURN")}, cancellable=true)
    private void researchtableenchantments$allowAromaticLure(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (this.researchtableenchantments$getAromaticLevel(player) > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    @Nullable
    private class_1657 researchtableenchantments$findAromaticPlayer(class_1937 world, class_1309 entity, class_4051 targetPredicate) {
        double baseRange = this.researchtableenchantments$getBaseRange(targetPredicate);
        class_1657 best = null;
        double bestDistance = Double.MAX_VALUE;
        for (class_1657 player : world.method_18456()) {
            int level = this.researchtableenchantments$getAromaticLevel(player);
            if (level <= 0 || !targetPredicate.method_18419(entity, (class_1309)player)) continue;
            double maxRange = baseRange + (double)level * 3.0;
            double distance = player.method_5858((class_1297)entity);
            if (distance > maxRange * maxRange || !(distance < bestDistance)) continue;
            best = player;
            bestDistance = distance;
        }
        return best;
    }

    @Unique
    private double researchtableenchantments$getBaseRange() {
        return this.researchtableenchantments$getBaseRange(this.field_28404);
    }

    @Unique
    private double researchtableenchantments$getBaseRange(class_4051 targetPredicate) {
        class_4051 effective;
        class_4051 class_40512 = effective = targetPredicate != null ? targetPredicate : this.field_28404;
        if (effective instanceof TargetPredicateAccessor) {
            TargetPredicateAccessor accessor = (TargetPredicateAccessor)effective;
            return accessor.researchtableenchantments$getBaseMaxDistance();
        }
        return 10.0;
    }

    @Unique
    private int researchtableenchantments$getAromaticLevel(@Nullable class_1657 player) {
        if (player == null) {
            return 0;
        }
        int mainHand = this.researchtableenchantments$getAromaticLevel(player.method_5998(class_1268.field_5808));
        int offHand = this.researchtableenchantments$getAromaticLevel(player.method_5998(class_1268.field_5810));
        return Math.max(mainHand, offHand);
    }

    @Unique
    private int researchtableenchantments$getAromaticLevel(class_1799 stack) {
        if (stack.method_7960() || !(stack.method_7909() instanceof class_1794)) {
            return 0;
        }
        return class_1890.method_8225((class_1887)ModEnchantments.AROMATIC, (class_1799)stack);
    }
}

