/*
 * Decompiled with CFR 0.152.
 */
package com.jamsackman.researchtableenchantments.client.gui;

import com.jamsackman.researchtableenchantments.status.ModStatusEffects;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public final class LastStandOverlayRenderer {
    private static final int ICON_SIZE = 18;
    private static final int BORDER_COLOR = -2039584;
    private static final int ACTIVE_FILL = -856373950;
    private static final int ACTIVE_TEXT = -13950464;
    private static final int COOLDOWN_FILL = -863072626;
    private static final int COOLDOWN_TEXT = -14803426;

    private LastStandOverlayRenderer() {
    }

    public static void register() {
        HudRenderCallback.EVENT.register((context, tickDelta) -> {
            class_310 client = class_310.method_1551();
            if (client == null || client.field_1690.field_1842 || client.field_1724 == null) {
                return;
            }
            if (client.field_1755 instanceof class_490) {
                return;
            }
            VisualState state = LastStandOverlayRenderer.resolveState((class_1657)client.field_1724);
            if (state == null) {
                return;
            }
            int x = 6;
            int y = client.method_22683().method_4502() / 2 - 18 - 4;
            LastStandOverlayRenderer.drawIcon(context, x, y, state);
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenEvents.afterRender((class_437)screen).register((scr, context, mouseX, mouseY, delta) -> LastStandOverlayRenderer.renderOnScreen(scr, context)));
    }

    private static void renderOnScreen(class_437 screen, class_332 context) {
        if (!(screen instanceof class_490)) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        VisualState state = LastStandOverlayRenderer.resolveState((class_1657)client.field_1724);
        if (state == null) {
            return;
        }
        int x = Math.max(6, screen.field_22789 / 2 - 88 - 18 - 6);
        int y = screen.field_22790 / 2 - 18 - 8;
        LastStandOverlayRenderer.drawIcon(context, x, y, state);
    }

    private static VisualState resolveState(class_1657 player) {
        class_1293 active = player.method_6112(ModStatusEffects.LAST_STAND_ACTIVE);
        if (active != null) {
            return VisualState.ACTIVE;
        }
        class_1293 cooldown = player.method_6112(ModStatusEffects.LAST_STAND_COOLDOWN);
        if (cooldown != null) {
            return VisualState.COOLDOWN;
        }
        return null;
    }

    private static void drawIcon(class_332 context, int x, int y, VisualState state) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1772 == null) {
            return;
        }
        int fillColor = state == VisualState.ACTIVE ? -856373950 : -863072626;
        int textColor = state == VisualState.ACTIVE ? -13950464 : -14803426;
        class_5250 label = state == VisualState.ACTIVE ? class_2561.method_43470((String)"LS") : class_2561.method_43470((String)"X");
        context.method_25294(x, y, x + 18, y + 18, fillColor);
        context.method_49601(x, y, 18, 18, -2039584);
        class_327 class_3272 = client.field_1772;
        Objects.requireNonNull(client.field_1772);
        context.method_27534(class_3272, (class_2561)label, x + 9, y + (18 - 9) / 2, textColor);
    }

    @Environment(value=EnvType.CLIENT)
    private static enum VisualState {
        ACTIVE,
        COOLDOWN;

    }
}

