/*
 * Decompiled with CFR 0.152.
 */
package com.jamsackman.researchtableenchantments.mixin;

import com.jamsackman.researchtableenchantments.access.LeechingHealTracker;
import com.jamsackman.researchtableenchantments.access.VoidtideImpactAccess;
import com.jamsackman.researchtableenchantments.registry.ModEnchantments;
import com.jamsackman.researchtableenchantments.status.ModStatusEffects;
import com.jamsackman.researchtableenchantments.util.AuraVisualHelper;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1894;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements VoidtideImpactAccess,
LeechingHealTracker {
    private static final float HYPOTHERMIA_CHANCE_PER_LEVEL = 0.1f;
    private static final int HYPOTHERMIA_DURATION_TICKS = 100;
    private static final float EVASIVE_CHANCE_PER_LEVEL = 0.1f;
    private static final int LAST_STAND_DURATION_TICKS = 100;
    private static final int LAST_STAND_COOLDOWN_DURATION_TICKS = 1200;
    private static final UUID LONGSTRIDER_SPEED_MODIFIER_ID = UUID.fromString("46e75281-2a70-4e8a-9cd8-32af3c8e90f1");
    private static final double LONGSTRIDER_SPEED_PER_LEVEL = 0.1;
    private static final UUID HARDENED_TOUGHNESS_MODIFIER_ID = UUID.fromString("b03b1f7e-1d75-4ec0-9400-1f4e0c9a1a8c");
    private static final double HARDENED_TOUGHNESS_PER_LEVEL = 1.0;
    private static final UUID HARES_BLESSING_LUCK_MODIFIER_ID = UUID.fromString("ff6b2d09-6736-4715-98e0-0f6df602c18a");
    private static final int FROSTBITE_DURATION_TICKS = 30;
    private static final int FROSTBITE_FROZEN_TICKS = 80;
    @Unique
    private static final int FIRE_MANTLE_DELAY_TICKS = 30;
    private static final int HARBINGER_INTERVAL_TICKS = 100;
    private static final int HEROIC_AURA_INTERVAL_TICKS = 100;
    private static final int INDUSTRIOUS_AURA_INTERVAL_TICKS = 100;
    private static final int LUCKY_AURA_INTERVAL_TICKS = 100;
    private static final double HEROIC_AURA_RANGE = 6.0;
    private static final float HEROIC_AURA_RED = 0.95f;
    private static final float HEROIC_AURA_GREEN = 0.4f;
    private static final float HEROIC_AURA_BLUE = 0.08f;
    private static final float INDUSTRIOUS_AURA_RED = 0.98f;
    private static final float INDUSTRIOUS_AURA_GREEN = 0.95f;
    private static final float INDUSTRIOUS_AURA_BLUE = 0.55f;
    private static final float LUCKY_AURA_RED = 0.2f;
    private static final float LUCKY_AURA_GREEN = 0.85f;
    private static final float LUCKY_AURA_BLUE = 0.3f;
    private static final float HARDCOAT_REDUCTION_PER_LEVEL = 0.08f;
    private boolean researchtableenchantments$lastStandTriggered;
    private int researchtableenchantments$lastStandTicks;
    private int researchtableenchantments$harbingerTicks;
    private int researchtableenchantments$heroicAuraTicks;
    private int researchtableenchantments$industriousAuraTicks;
    private int researchtableenchantments$luckyAuraTicks;
    private int researchtableenchantments$voidtideImpactTicks;
    private int researchtableenchantments$voidtideImpactLevel;
    private long researchtableenchantments$lastLeechHealTick;

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void researchtableenchantments$applyLongstriderBonus(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        class_1324 movement = self.method_5996(class_5134.field_23719);
        if (movement == null) {
            return;
        }
        int level = class_1890.method_8225((class_1887)ModEnchantments.LONGSTRIDER, (class_1799)self.method_6118(class_1304.field_6166));
        if (level <= 0) {
            if (movement.method_6199(LONGSTRIDER_SPEED_MODIFIER_ID) != null) {
                movement.method_6200(LONGSTRIDER_SPEED_MODIFIER_ID);
            }
            return;
        }
        double bonus = (double)level * 0.1;
        class_1322 modifier = new class_1322(LONGSTRIDER_SPEED_MODIFIER_ID, "Longstrider speed bonus", bonus, class_1322.class_1323.field_6330);
        class_1322 existing = movement.method_6199(LONGSTRIDER_SPEED_MODIFIER_ID);
        if (existing != null && existing.method_6186() == modifier.method_6186()) {
            return;
        }
        movement.method_6200(LONGSTRIDER_SPEED_MODIFIER_ID);
        movement.method_26837(modifier);
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void researchtableenchantments$tickVoidtideImpact(CallbackInfo ci) {
        if (this.researchtableenchantments$voidtideImpactTicks > 0) {
            --this.researchtableenchantments$voidtideImpactTicks;
            if (this.researchtableenchantments$voidtideImpactTicks == 0) {
                this.researchtableenchantments$voidtideImpactLevel = 0;
            }
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void researchtableenchantments$freezeWaterWithWaterStrider(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        if (!(self instanceof class_1496)) {
            return;
        }
        class_1496 horse = (class_1496)self;
        int level = class_1890.method_8225((class_1887)ModEnchantments.WATER_STRIDER, (class_1799)horse.method_6118(class_1304.field_6174));
        if (level <= 0) {
            return;
        }
        class_1894.method_8236((class_1309)horse, (class_1937)horse.method_37908(), (class_2338)horse.method_24515(), (int)level);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void researchtableenchantments$applyHardenedToughness(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        class_1324 toughness = self.method_5996(class_5134.field_23725);
        if (toughness == null) {
            return;
        }
        int level = Math.max(class_1890.method_8225((class_1887)ModEnchantments.HARDENED, (class_1799)self.method_6047()), class_1890.method_8225((class_1887)ModEnchantments.HARDENED, (class_1799)self.method_6079()));
        if (level <= 0) {
            if (toughness.method_6199(HARDENED_TOUGHNESS_MODIFIER_ID) != null) {
                toughness.method_6200(HARDENED_TOUGHNESS_MODIFIER_ID);
            }
            return;
        }
        double bonus = (double)level * 1.0;
        class_1322 modifier = new class_1322(HARDENED_TOUGHNESS_MODIFIER_ID, "Hardened shield toughness", bonus, class_1322.class_1323.field_6328);
        class_1322 existing = toughness.method_6199(HARDENED_TOUGHNESS_MODIFIER_ID);
        if (existing != null && existing.method_6186() == modifier.method_6186()) {
            return;
        }
        toughness.method_6200(HARDENED_TOUGHNESS_MODIFIER_ID);
        toughness.method_26837(modifier);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void researchtableenchantments$applyHaresBlessingLuck(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        class_1324 luck = self.method_5996(class_5134.field_23726);
        if (luck == null) {
            return;
        }
        int level = Math.max(class_1890.method_8225((class_1887)ModEnchantments.HARES_BLESSING, (class_1799)self.method_6047()), class_1890.method_8225((class_1887)ModEnchantments.HARES_BLESSING, (class_1799)self.method_6079()));
        if (level <= 0) {
            if (luck.method_6199(HARES_BLESSING_LUCK_MODIFIER_ID) != null) {
                luck.method_6200(HARES_BLESSING_LUCK_MODIFIER_ID);
            }
            return;
        }
        class_1322 modifier = new class_1322(HARES_BLESSING_LUCK_MODIFIER_ID, "Hare's Blessing luck", (double)level, class_1322.class_1323.field_6328);
        class_1322 existing = luck.method_6199(HARES_BLESSING_LUCK_MODIFIER_ID);
        if (existing != null && existing.method_6186() == modifier.method_6186()) {
            return;
        }
        luck.method_6200(HARES_BLESSING_LUCK_MODIFIER_ID);
        luck.method_26837(modifier);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void researchtableenchantments$applyHarbingerOmen(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        int level = Math.max(class_1890.method_8225((class_1887)ModEnchantments.HARBINGER, (class_1799)self.method_6047()), class_1890.method_8225((class_1887)ModEnchantments.HARBINGER, (class_1799)self.method_6079()));
        if (level <= 0) {
            this.researchtableenchantments$harbingerTicks = 0;
            return;
        }
        if (this.researchtableenchantments$harbingerTicks > 0) {
            --this.researchtableenchantments$harbingerTicks;
            return;
        }
        this.researchtableenchantments$harbingerTicks = 100;
        int amplifier = level - 1;
        self.method_6092(new class_1293(class_1294.field_16595, 100, amplifier, true, true, true));
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void researchtableenchantments$applyHeroicAura(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        int level = class_1890.method_8225((class_1887)ModEnchantments.HEROIC_AURA, (class_1799)self.method_6118(class_1304.field_6174));
        if (level <= 0) {
            this.researchtableenchantments$heroicAuraTicks = 0;
            return;
        }
        if (this.researchtableenchantments$heroicAuraTicks > 0) {
            --this.researchtableenchantments$heroicAuraTicks;
            return;
        }
        this.researchtableenchantments$heroicAuraTicks = 100;
        int duration = Math.max(1, level * 20);
        double rangeSquared = 36.0;
        for (class_1657 player : self.method_37908().method_18456()) {
            if (player == self || player.method_5858((class_1297)self) > rangeSquared) continue;
            player.method_6092(new class_1293(class_1294.field_5910, duration, 0, true, true, true));
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void researchtableenchantments$applyIndustriousAura(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        int level = class_1890.method_8225((class_1887)ModEnchantments.INDUSTRIOUS_AURA, (class_1799)self.method_6118(class_1304.field_6174));
        if (level <= 0) {
            this.researchtableenchantments$industriousAuraTicks = 0;
            return;
        }
        if (this.researchtableenchantments$industriousAuraTicks > 0) {
            --this.researchtableenchantments$industriousAuraTicks;
            return;
        }
        this.researchtableenchantments$industriousAuraTicks = 100;
        int duration = Math.max(1, level * 20);
        double rangeSquared = 36.0;
        for (class_1657 player : self.method_37908().method_18456()) {
            if (player == self || player.method_5858((class_1297)self) > rangeSquared) continue;
            player.method_6092(new class_1293(class_1294.field_5917, duration, 0, true, true, true));
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void researchtableenchantments$applyLuckyAura(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        int level = class_1890.method_8225((class_1887)ModEnchantments.LUCKY_AURA, (class_1799)self.method_6118(class_1304.field_6174));
        if (level <= 0) {
            this.researchtableenchantments$luckyAuraTicks = 0;
            return;
        }
        if (this.researchtableenchantments$luckyAuraTicks > 0) {
            --this.researchtableenchantments$luckyAuraTicks;
            return;
        }
        this.researchtableenchantments$luckyAuraTicks = 100;
        int duration = Math.max(1, level * 20);
        double rangeSquared = 36.0;
        for (class_1657 player : self.method_37908().method_18456()) {
            if (player == self || player.method_5858((class_1297)self) > rangeSquared) continue;
            player.method_6092(new class_1293(class_1294.field_5926, duration, 0, true, true, true));
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void researchtableenchantments$tickLastStand(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        if (this.researchtableenchantments$lastStandTicks > 0) {
            --this.researchtableenchantments$lastStandTicks;
            if (this.researchtableenchantments$lastStandTicks == 0 && !self.method_37908().field_9236) {
                self.method_6016(ModStatusEffects.LAST_STAND_ACTIVE);
                if (this.researchtableenchantments$lastStandTriggered && !self.method_6059(ModStatusEffects.LAST_STAND_COOLDOWN)) {
                    self.method_6092(new class_1293(ModStatusEffects.LAST_STAND_COOLDOWN, 1200, 0, true, false, true));
                }
            }
        } else if (!self.method_37908().field_9236 && !this.researchtableenchantments$lastStandTriggered && self.method_6059(ModStatusEffects.LAST_STAND_COOLDOWN)) {
            self.method_6016(ModStatusEffects.LAST_STAND_COOLDOWN);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void researchtableenchantments$renderAuraEffects(CallbackInfo ci) {
        int luckyAura;
        int industriousAura;
        int heroicAura;
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        int necroticLevel = Math.max(class_1890.method_8225((class_1887)ModEnchantments.NECROTIC_AURA, (class_1799)self.method_6047()), class_1890.method_8225((class_1887)ModEnchantments.NECROTIC_AURA, (class_1799)self.method_6079()));
        if (necroticLevel > 0) {
            AuraVisualHelper.emitAuraRing(self, 1, 0.05f, 0.05f, 0.05f);
        }
        if ((heroicAura = class_1890.method_8225((class_1887)ModEnchantments.HEROIC_AURA, (class_1799)self.method_6118(class_1304.field_6174))) > 0) {
            AuraVisualHelper.emitAuraRing(self, 5, 0.95f, 0.4f, 0.08f);
        }
        if ((industriousAura = class_1890.method_8225((class_1887)ModEnchantments.INDUSTRIOUS_AURA, (class_1799)self.method_6118(class_1304.field_6174))) > 0) {
            AuraVisualHelper.emitAuraRing(self, 10, 0.98f, 0.95f, 0.55f);
        }
        if ((luckyAura = class_1890.method_8225((class_1887)ModEnchantments.LUCKY_AURA, (class_1799)self.method_6118(class_1304.field_6174))) > 0) {
            AuraVisualHelper.emitAuraRing(self, 15, 0.2f, 0.85f, 0.3f);
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="TAIL")})
    private void researchtableenchantments$resetLastStandState(class_1282 source, CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        this.researchtableenchantments$lastStandTicks = 0;
        this.researchtableenchantments$lastStandTriggered = false;
        if (!self.method_37908().field_9236) {
            self.method_6016(ModStatusEffects.LAST_STAND_ACTIVE);
            self.method_6016(ModStatusEffects.LAST_STAND_COOLDOWN);
        }
    }

    @Inject(method={"takeKnockback"}, at={@At(value="HEAD")}, cancellable=true)
    private void researchtableenchantments$negateKnockback(double strength, double x, double z, CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        int level = class_1890.method_8225((class_1887)ModEnchantments.JUGGERNAUT, (class_1799)self.method_6118(class_1304.field_6172));
        if (level > 0) {
            ci.cancel();
        }
    }

    @Inject(method={"blockedByShield"}, at={@At(value="RETURN")})
    private void researchtableenchantments$applyFrostbite(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        class_1799 activeStack = self.method_6030();
        if (activeStack.method_7960() || !(activeStack.method_7909() instanceof class_1819)) {
            return;
        }
        int frostbiteLevel = class_1890.method_8225((class_1887)ModEnchantments.FROSTBITE, (class_1799)activeStack);
        int fireMantleLevel = class_1890.method_8225((class_1887)ModEnchantments.FIRE_MANTLE, (class_1799)activeStack);
        if (frostbiteLevel <= 0 && fireMantleLevel <= 0) {
            return;
        }
        class_1309 attacker = LivingEntityMixin.researchtableenchantments$getBlockingAttacker(source);
        if (attacker == null || attacker == self) {
            return;
        }
        if (frostbiteLevel > 0) {
            attacker.method_6092(new class_1293(ModStatusEffects.FROSTBITE, 30, Math.max(0, frostbiteLevel - 1), false, true, true));
            attacker.method_32317(Math.max(attacker.method_32312(), 80));
            class_1937 class_19372 = self.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_2388 iceParticles = new class_2388(class_2398.field_11217, class_2246.field_10110.method_9564());
                class_243 center = attacker.method_19538();
                double horizontalSpread = Math.max((double)attacker.method_17681() * 0.35, 0.3);
                double y = attacker.method_5829().field_1322 + 0.1;
                serverWorld.method_14199((class_2394)iceParticles, center.field_1352, y, center.field_1350, 24, horizontalSpread, 0.15, horizontalSpread, 0.05);
            }
        }
        if (fireMantleLevel > 0) {
            attacker.method_6092(new class_1293(ModStatusEffects.FIRE_MANTLE_MARK, 30, Math.max(0, fireMantleLevel - 1), false, true, true));
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void researchtableenchantments$blockDamageDuringLastStand(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.researchtableenchantments$lastStandTicks > 0) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void researchtableenchantments$maybeEvadeProjectile(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source == null || !source.method_48789(class_8103.field_42247)) {
            return;
        }
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        int level = class_1890.method_8225((class_1887)ModEnchantments.EVASIVE, (class_1799)self.method_6118(class_1304.field_6172));
        if (level <= 0) {
            return;
        }
        float chance = (float)level * 0.1f;
        if (chance <= 0.0f) {
            return;
        }
        if (self.method_6051().method_43057() < chance) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyArgs(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"))
    private void researchtableenchantments$scaleFlyIntoWallDamage(Args args) {
        class_1282 source = (class_1282)args.get(0);
        if (source == null || !source.method_49708(class_8111.field_42346)) {
            return;
        }
        float amount = ((Float)args.get(1)).floatValue();
        class_1309 self = (class_1309)this;
        int level = class_1890.method_8203((class_1887)ModEnchantments.SOFT_IMPACT, (class_1309)self);
        if (level <= 0) {
            float voidtideMultiplier = this.researchtableenchantments$getVoidtideImpactMultiplier();
            if (voidtideMultiplier != 1.0f) {
                args.set(1, (Object)Float.valueOf(amount * voidtideMultiplier));
            }
            return;
        }
        float multiplier = Math.max(0.0f, 1.0f - 0.08f * (float)level);
        args.set(1, (Object)Float.valueOf(amount * (multiplier *= this.researchtableenchantments$getVoidtideImpactMultiplier())));
    }

    @ModifyArgs(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"))
    private void researchtableenchantments$scaleFallDamage(Args args) {
        class_1282 source = (class_1282)args.get(0);
        if (source == null || !source.method_49708(class_8111.field_42345)) {
            return;
        }
        float amount = ((Float)args.get(1)).floatValue();
        float multiplier = this.researchtableenchantments$getVoidtideImpactMultiplier();
        if (multiplier != 1.0f) {
            args.set(1, (Object)Float.valueOf(amount * multiplier));
        }
    }

    @ModifyArgs(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"))
    private void researchtableenchantments$applyHardcoatReduction(Args args) {
        class_1309 self = (class_1309)this;
        if (!(self instanceof class_1496)) {
            return;
        }
        class_1496 horse = (class_1496)self;
        int level = class_1890.method_8225((class_1887)ModEnchantments.HARDCOAT, (class_1799)horse.method_6118(class_1304.field_6174));
        if (level <= 0) {
            return;
        }
        float amount = ((Float)args.get(1)).floatValue();
        float multiplier = Math.max(0.0f, 1.0f - 0.08f * (float)level);
        args.set(1, (Object)Float.valueOf(amount * multiplier));
    }

    @ModifyVariable(method={"travel(Lnet/minecraft/util/math/Vec3d;)V"}, at=@At(value="STORE"), ordinal=0)
    private double researchtableenchantments$applyMoonwalkGravity(double gravity) {
        class_1309 self = (class_1309)this;
        int level = class_1890.method_8203((class_1887)ModEnchantments.MOONWALK, (class_1309)self);
        if (level <= 0) {
            return gravity;
        }
        return Math.max(0.0, gravity - 0.03 * (double)level);
    }

    @ModifyVariable(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1293 researchtableenchantments$adjustNegativeEffectDuration(class_1293 effect) {
        if (effect == null) {
            return effect;
        }
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return effect;
        }
        if (effect.method_5579() == class_1294.field_5899) {
            int level = class_1890.method_8225((class_1887)ModEnchantments.ANTIDOTE, (class_1799)self.method_6118(class_1304.field_6174));
            return this.researchtableenchantments$shortenEffect(effect, level);
        }
        if (effect.method_5579() == class_1294.field_5920) {
            int level = class_1890.method_8225((class_1887)ModEnchantments.DIVINE, (class_1799)self.method_6118(class_1304.field_6174));
            return this.researchtableenchantments$shortenEffect(effect, level);
        }
        return effect;
    }

    private class_1293 researchtableenchantments$shortenEffect(class_1293 effect, int level) {
        if (level <= 0 || effect == null) {
            return effect;
        }
        if (effect.method_5579().method_5561() || effect.method_5584() <= 0) {
            return effect;
        }
        double multiplier = Math.max(0.0, 1.0 - (double)level * 0.25);
        int adjustedDuration = (int)Math.floor((double)effect.method_5584() * multiplier);
        if (adjustedDuration >= effect.method_5584()) {
            return effect;
        }
        return new class_1293(effect.method_5579(), Math.max(1, adjustedDuration), effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592());
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void researchtableenchantments$applyHypothermia(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 attacker;
        if (!cir.getReturnValueZ()) {
            return;
        }
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        int level = class_1890.method_8225((class_1887)ModEnchantments.HYPOTHERMIA, (class_1799)self.method_6118(class_1304.field_6172));
        if (level <= 0) {
            return;
        }
        class_1297 attackerEntity = source.method_5529();
        if (!(attackerEntity instanceof class_1309) || (attacker = (class_1309)attackerEntity) == self) {
            return;
        }
        if (source.method_5526() != attacker) {
            return;
        }
        float chance = (float)level * 0.1f;
        if (chance <= 0.0f) {
            return;
        }
        if (self.method_6051().method_43057() >= chance) {
            return;
        }
        attacker.method_6092(new class_1293(class_1294.field_5911, 100, 0));
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void researchtableenchantments$maybeTriggerLastStand(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236 || self.method_29504()) {
            return;
        }
        if (self.method_6032() > 6.0f || this.researchtableenchantments$lastStandTriggered) {
            return;
        }
        int level = class_1890.method_8225((class_1887)ModEnchantments.LAST_STAND, (class_1799)self.method_6118(class_1304.field_6166));
        if (level <= 0) {
            return;
        }
        this.researchtableenchantments$lastStandTriggered = true;
        this.researchtableenchantments$lastStandTicks = 100;
        ArrayList<class_1291> toRemove = new ArrayList<class_1291>();
        for (class_1293 instance : self.method_6026()) {
            if (instance.method_5579().method_18792() != class_4081.field_18272) continue;
            toRemove.add(instance.method_5579());
        }
        for (class_1291 effect : toRemove) {
            self.method_6016(effect);
        }
        self.method_6016(ModStatusEffects.LAST_STAND_COOLDOWN);
        self.method_6092(new class_1293(ModStatusEffects.LAST_STAND_ACTIVE, 100, 0, false, true, true));
        self.method_37908().method_43128(null, self.method_23317(), self.method_23318(), self.method_23321(), class_3417.field_14931, self.method_5634(), 1.0f, 1.0f);
        class_1937 class_19372 = self.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)class_2398.field_11220, self.method_23317(), self.method_23323(0.5), self.method_23321(), 20, 0.5, 0.5, 0.5, 0.0);
        }
    }

    @Inject(method={"travel(Lnet/minecraft/util/math/Vec3d;)V"}, at={@At(value="TAIL")})
    private void researchtableenchantments$boostLavaTraversal(class_243 movementInput, CallbackInfo ci) {
        double newY;
        class_1309 self = (class_1309)this;
        int level = class_1890.method_8225((class_1887)ModEnchantments.SALAMANDER, (class_1799)self.method_6118(class_1304.field_6172));
        if (level <= 0) {
            return;
        }
        if (!self.method_5771() && !self.method_5777(class_3486.field_15518)) {
            return;
        }
        class_243 velocity = self.method_18798();
        if (velocity.method_1027() < 1.0E-6) {
            return;
        }
        double horizontalMultiplier = 1.0 + (double)level * 0.25;
        double newX = velocity.field_1352;
        double newZ = velocity.field_1350;
        if (newX != 0.0 || newZ != 0.0) {
            newX *= horizontalMultiplier;
            newZ *= horizontalMultiplier;
        }
        if ((newY = velocity.field_1351) > 0.0) {
            newY *= 1.0 + (double)level * 0.2;
        }
        self.method_18800(newX, newY, newZ);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    private float researchtableenchantments$applyStrikeTweaks(float amount, class_1282 source) {
        int lethalLevel;
        class_1297 attackerEntity = source.method_5529();
        if (!(attackerEntity instanceof class_1309)) {
            return amount;
        }
        class_1309 attacker = (class_1309)attackerEntity;
        class_1799 weapon = attacker.method_6047();
        if (!(weapon.method_7909() instanceof class_1829) && !(weapon.method_7909() instanceof class_1743)) {
            return amount;
        }
        float modified = amount;
        int criticalLevel = class_1890.method_8225((class_1887)ModEnchantments.CRITICAL_STRIKE, (class_1799)weapon);
        if (criticalLevel > 0 && attacker instanceof class_1657) {
            boolean isCritical;
            class_1657 player = (class_1657)attacker;
            boolean bl = isCritical = player.field_6017 > 0.0f && !player.method_24828() && !player.method_6101() && !player.method_5799() && !player.method_6059(class_1294.field_5919) && !player.method_5765() && !player.method_5624();
            if (isCritical) {
                modified *= 1.0f + 0.125f * (float)criticalLevel;
            }
        }
        if ((lethalLevel = class_1890.method_8225((class_1887)ModEnchantments.LETHAL_STRIKE, (class_1799)weapon)) > 0) {
            class_1309 self = (class_1309)this;
            float armor = self.method_6096();
            float toughness = (float)self.method_26825(class_5134.field_23725);
            float afterArmor = LivingEntityMixin.researchtableenchantments$predictLethalArmorReduction(modified, armor, toughness);
            float mitigated = modified - afterArmor;
            modified += mitigated * ((float)lethalLevel * 0.05f);
        }
        return modified;
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void researchtableenchantments$applyAspectHits(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        int leechingStrikeLevel;
        class_1309 attacker;
        if (!cir.getReturnValueZ()) {
            return;
        }
        class_1309 self = (class_1309)this;
        if (self.method_37908().field_9236) {
            return;
        }
        class_1297 attackerEntity = source.method_5529();
        if (!(attackerEntity instanceof class_1309) || (attacker = (class_1309)attackerEntity) == self) {
            return;
        }
        if (source.method_5526() != attacker) {
            return;
        }
        class_1799 weapon = attacker.method_6047();
        boolean isSword = weapon.method_7909() instanceof class_1829;
        boolean isAxe = weapon.method_7909() instanceof class_1743;
        if (!isSword && !isAxe) {
            return;
        }
        if (isSword) {
            int venomLevel;
            int witherLevel;
            int frostLevel = class_1890.method_8225((class_1887)ModEnchantments.FROST_ASPECT, (class_1799)weapon);
            if (frostLevel > 0) {
                int duration = frostLevel * 40;
                self.method_6092(new class_1293(ModStatusEffects.FROST_ASPECT, duration, frostLevel - 1));
            }
            if ((witherLevel = class_1890.method_8225((class_1887)ModEnchantments.WITHER_ASPECT, (class_1799)weapon)) > 0) {
                self.method_6092(new class_1293(class_1294.field_5920, 160, witherLevel - 1));
            }
            if ((venomLevel = class_1890.method_8225((class_1887)ModEnchantments.VENOM_ASPECT, (class_1799)weapon)) > 0) {
                self.method_6092(new class_1293(class_1294.field_5899, venomLevel * 200, 0));
            }
        }
        if ((leechingStrikeLevel = class_1890.method_8225((class_1887)ModEnchantments.LEECHING_STRIKE, (class_1799)weapon)) > 0 && attacker instanceof LeechingHealTracker) {
            LeechingHealTracker tracker = (LeechingHealTracker)attacker;
            long currentTick = attacker.method_37908().method_8510();
            if (tracker.researchtableenchantments$getLastLeechHealTick() != currentTick) {
                tracker.researchtableenchantments$setLastLeechHealTick(currentTick);
                attacker.method_6025((float)leechingStrikeLevel * 0.5f);
            }
        }
    }

    @Unique
    private static float researchtableenchantments$predictLethalArmorReduction(float amount, float armor, float toughness) {
        float armorFactor = Math.max(armor * 0.04f, armor - amount / (2.0f + toughness * 0.5f));
        float clamped = Math.min(armorFactor, 20.0f);
        return amount * (1.0f - clamped / 25.0f);
    }

    @Override
    public void researchtableenchantments$activateVoidtideImpact(int level) {
        this.researchtableenchantments$voidtideImpactLevel = Math.max(this.researchtableenchantments$voidtideImpactLevel, level);
        this.researchtableenchantments$voidtideImpactTicks = 60;
    }

    @Override
    public float researchtableenchantments$getVoidtideImpactMultiplier() {
        if (this.researchtableenchantments$voidtideImpactTicks <= 0 || this.researchtableenchantments$voidtideImpactLevel <= 0) {
            return 1.0f;
        }
        return Math.max(0.0f, 1.0f - 0.06f * (float)this.researchtableenchantments$voidtideImpactLevel);
    }

    @Override
    public long researchtableenchantments$getLastLeechHealTick() {
        return this.researchtableenchantments$lastLeechHealTick;
    }

    @Override
    public void researchtableenchantments$setLastLeechHealTick(long tick) {
        this.researchtableenchantments$lastLeechHealTick = tick;
    }

    @Unique
    private static class_1309 researchtableenchantments$getBlockingAttacker(class_1282 source) {
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1309) {
            class_1309 living = (class_1309)attacker;
            return living;
        }
        class_1297 direct = source.method_5526();
        if (direct instanceof class_1309) {
            class_1309 livingDirect = (class_1309)direct;
            return livingDirect;
        }
        return null;
    }
}

