/*
 * Decompiled with CFR 0.152.
 */
package com.jamsackman.researchtableenchantments.mixin;

import com.jamsackman.researchtableenchantments.access.StepHeightAccess;
import com.jamsackman.researchtableenchantments.enchantment.safekeep.SafekeepStorage;
import com.jamsackman.researchtableenchantments.registry.ModEnchantments;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements SafekeepStorage {
    @Unique
    private final EnumMap<class_1304, class_1799> researchtableenchantments$safekeepItems = new EnumMap(class_1304.class);
    @Unique
    private int researchtableenchantments$darkSightRefreshTicks = 0;
    @Unique
    private final Map<class_1542, Boolean> researchtableenchantments$seekerGlowingItems = new HashMap<class_1542, Boolean>();
    @Unique
    private int researchtableenchantments$previousAirSupply = 0;
    @Unique
    private double researchtableenchantments$oceanHeartCompensation = 0.0;
    @Unique
    private float researchtableenchantments$defaultStepHeight = Float.NaN;
    @Unique
    private static final UUID RESEARCHTABLEENCHANTMENTS$QUICK_STRIKE_ID = UUID.fromString("1b6b0b8a-0c7d-4b02-93d2-1f5f3d7c1d3a");

    @Inject(method={"dropInventory"}, at={@At(value="HEAD")})
    private void researchtableenchantments$captureSafekeepItems(CallbackInfo ci) {
        class_1657 self = (class_1657)this;
        if (self.method_37908().field_9236) {
            return;
        }
        this.researchtableenchantments$clearSeekerHighlights();
        this.researchtableenchantments$safekeepItems.clear();
        for (class_1304 slot : class_1304.values()) {
            int level;
            class_1799 stack;
            if (slot.method_5925() != class_1304.class_1305.field_6178 || (stack = self.method_6118(slot)).method_7960() || (level = class_1890.method_8225((class_1887)ModEnchantments.SAFEKEEP, (class_1799)stack)) <= 0) continue;
            this.researchtableenchantments$safekeepItems.put(slot, stack.method_7972());
            self.method_5673(slot, class_1799.field_8037);
        }
    }

    @Override
    public Map<class_1304, class_1799> researchtableenchantments$getSafekeepItems() {
        return this.researchtableenchantments$safekeepItems;
    }

    @Override
    public void researchtableenchantments$clearSafekeep() {
        this.researchtableenchantments$safekeepItems.clear();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void researchtableenchantments$applyDarkSight(CallbackInfo ci) {
        boolean isDarkSightEffect;
        class_1657 self = (class_1657)this;
        this.researchtableenchantments$previousAirSupply = self.method_5669();
        this.researchtableenchantments$applyHikerStepHeight(self);
        this.researchtableenchantments$applyQuickStrike(self);
        if (self.method_37908().field_9236) {
            return;
        }
        class_1799 leggings = self.method_6118(class_1304.field_6172);
        if (self.method_5715() && class_1890.method_8225((class_1887)ModEnchantments.HOT_POCKETS, (class_1799)leggings) > 0) {
            this.researchtableenchantments$dryHandSponges(self, class_1268.field_5808);
            this.researchtableenchantments$dryHandSponges(self, class_1268.field_5810);
        }
        class_1799 helmet = self.method_6118(class_1304.field_6169);
        int level = class_1890.method_8225((class_1887)ModEnchantments.DARK_SIGHT, (class_1799)helmet);
        class_1293 existing = self.method_6112(class_1294.field_5925);
        boolean bl = isDarkSightEffect = existing != null && existing.method_5591() && !existing.method_5581() && !existing.method_5592();
        if (level > 0) {
            if (!isDarkSightEffect || existing == null) {
                self.method_6092(new class_1293(class_1294.field_5925, 300, 0, true, false, false));
                this.researchtableenchantments$darkSightRefreshTicks = 0;
            } else {
                ++this.researchtableenchantments$darkSightRefreshTicks;
                if (this.researchtableenchantments$darkSightRefreshTicks >= 20 || existing.method_5584() < 300) {
                    self.method_6092(new class_1293(class_1294.field_5925, 300, 0, true, false, false));
                    this.researchtableenchantments$darkSightRefreshTicks = 0;
                }
            }
        } else {
            this.researchtableenchantments$darkSightRefreshTicks = 0;
            if (isDarkSightEffect) {
                self.method_6016(class_1294.field_5925);
            }
        }
        int seekerLevel = class_1890.method_8225((class_1887)ModEnchantments.SEEKER, (class_1799)helmet);
        if (seekerLevel > 0) {
            double range = (double)seekerLevel * 4.0;
            HashSet nearbyItems = new HashSet(self.method_37908().method_8390(class_1542.class, self.method_5829().method_1014(range), item -> !item.method_31481()));
            for (class_1542 item2 : nearbyItems) {
                if (!this.researchtableenchantments$seekerGlowingItems.containsKey(item2)) {
                    this.researchtableenchantments$seekerGlowingItems.put(item2, item2.method_5851());
                }
                item2.method_5834(true);
            }
            Iterator<Map.Entry<class_1542, Boolean>> iterator = this.researchtableenchantments$seekerGlowingItems.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_1542, Boolean> entry = iterator.next();
                class_1542 item3 = entry.getKey();
                if (item3 != null && !item3.method_31481() && item3.method_37908() == self.method_37908() && nearbyItems.contains(item3)) continue;
                if (item3 != null && !entry.getValue().booleanValue() && !item3.method_31481()) {
                    item3.method_5834(false);
                }
                iterator.remove();
            }
        } else {
            this.researchtableenchantments$clearSeekerHighlights();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void researchtableenchantments$applyOceanHeart(CallbackInfo ci) {
        boolean underwater;
        class_1657 self = (class_1657)this;
        if (self.method_37908().field_9236) {
            return;
        }
        class_1799 chest = self.method_6118(class_1304.field_6174);
        int level = class_1890.method_8225((class_1887)ModEnchantments.OCEAN_HEART, (class_1799)chest);
        boolean bl = underwater = self.method_5869() || self.method_5816();
        if (level <= 0 || !underwater) {
            this.researchtableenchantments$oceanHeartCompensation = 0.0;
            return;
        }
        if (self.method_6094()) {
            this.researchtableenchantments$oceanHeartCompensation = 0.0;
            return;
        }
        int currentAir = self.method_5669();
        int lostAir = this.researchtableenchantments$previousAirSupply - currentAir;
        if (lostAir <= 0) {
            return;
        }
        double ratio = Math.min(0.8 * (double)level, 1.0);
        this.researchtableenchantments$oceanHeartCompensation += (double)lostAir * ratio;
        int toRestore = (int)this.researchtableenchantments$oceanHeartCompensation;
        if (toRestore <= 0) {
            return;
        }
        int maxAir = self.method_5748();
        int newAir = Math.min(maxAir, currentAir + toRestore);
        int applied = newAir - currentAir;
        if (applied > 0) {
            self.method_5855(newAir);
            this.researchtableenchantments$oceanHeartCompensation -= (double)applied;
        }
    }

    @Unique
    private void researchtableenchantments$clearSeekerHighlights() {
        if (this.researchtableenchantments$seekerGlowingItems.isEmpty()) {
            return;
        }
        for (Map.Entry<class_1542, Boolean> entry : this.researchtableenchantments$seekerGlowingItems.entrySet()) {
            class_1542 item = entry.getKey();
            if (item == null || entry.getValue().booleanValue() || item.method_31481()) continue;
            item.method_5834(false);
        }
        this.researchtableenchantments$seekerGlowingItems.clear();
    }

    @Unique
    private void researchtableenchantments$applyHikerStepHeight(class_1657 self) {
        class_1799 boots;
        boolean hasHiker;
        StepHeightAccess access = (StepHeightAccess)self;
        if (Float.isNaN(this.researchtableenchantments$defaultStepHeight)) {
            this.researchtableenchantments$defaultStepHeight = access.researchtableenchantments$getStepHeight();
        }
        boolean bl = hasHiker = class_1890.method_8225((class_1887)ModEnchantments.HIKER, (class_1799)(boots = self.method_6118(class_1304.field_6166))) > 0;
        if (hasHiker) {
            access.researchtableenchantments$setStepHeight(Math.max(this.researchtableenchantments$defaultStepHeight, 1.0f));
        } else {
            access.researchtableenchantments$setStepHeight(this.researchtableenchantments$defaultStepHeight);
        }
    }

    @Unique
    private void researchtableenchantments$dryHandSponges(class_1657 player, class_1268 hand) {
        class_1799 heldStack = player.method_5998(hand);
        if (!heldStack.method_31574(class_1802.field_8554)) {
            return;
        }
        class_1799 dried = new class_1799((class_1935)class_1802.field_8535, heldStack.method_7947());
        if (heldStack.method_7985()) {
            dried.method_7980(heldStack.method_7969().method_10553());
        }
        player.method_6122(hand, dried);
    }

    @Unique
    private void researchtableenchantments$applyQuickStrike(class_1657 self) {
        class_1324 attackSpeed = self.method_5996(class_5134.field_23723);
        if (attackSpeed == null) {
            return;
        }
        attackSpeed.method_6200(RESEARCHTABLEENCHANTMENTS$QUICK_STRIKE_ID);
        class_1799 mainHand = self.method_6047();
        if (!(mainHand.method_7909() instanceof class_1829) && !(mainHand.method_7909() instanceof class_1743)) {
            return;
        }
        int level = class_1890.method_8225((class_1887)ModEnchantments.QUICK_STRIKE, (class_1799)mainHand);
        if (level <= 0) {
            return;
        }
        double bonus = 0.06 * (double)level;
        attackSpeed.method_26837(new class_1322(RESEARCHTABLEENCHANTMENTS$QUICK_STRIKE_ID, "Quick Strike", bonus, class_1322.class_1323.field_6331));
    }
}

