/*
 * Decompiled with CFR 0.152.
 */
package net.openbagtwo.foxnap.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.constant.Constable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.openbagtwo.foxnap.FoxNap;
import {net.openbagtwo.fox-nap.shadow.org.yaml.snakeyaml.DumperOptions;
import {net.openbagtwo.fox-nap.shadow.org.yaml.snakeyaml.Yaml;

public class Config {
    private static final Path config_path = FabricLoader.getInstance().getConfigDir().resolve("foxnap.yaml").toAbsolutePath();
    private int numDiscs;
    private int maximumNumberOfDiscs;
    private boolean enableMaestro;
    private static final int DEFAULT_N_DISCS = 7;
    private static final int DEFAULT_MAX_DISCS = 64;
    private static final boolean DEFAULT_MAESTRO_ENABLED = true;
    private static final DumperOptions configFormat = new DumperOptions(){
        {
            this.setIndent(2);
            this.setPrettyFlow(true);
            this.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        }
    };

    public int getNumDiscs() {
        return this.numDiscs;
    }

    public void setNumDiscs(int numDiscs) {
        this.numDiscs = numDiscs;
    }

    public int getMaximumNumberOfDiscs() {
        return this.maximumNumberOfDiscs;
    }

    public void setMaxDiscs(int maxDiscs) {
        this.maximumNumberOfDiscs = maxDiscs;
    }

    public boolean getMaestroEnabled() {
        return this.enableMaestro;
    }

    public void setMaestroEnabled(boolean enable) {
        this.enableMaestro = enable;
    }

    public static Config loadConfiguration() {
        Config config;
        try {
            config = Config.fromConfigFile();
            FoxNap.LOGGER.debug("Loaded Fox Nap configuration.");
        }
        catch (FileNotFoundException e) {
            FoxNap.LOGGER.warn("No Fox Nap configuration file found.");
            try {
                Config.writeDefaultConfigFile();
            }
            catch (ConfigException writee) {
                FoxNap.LOGGER.error("Could not write Fox Nap configuration:\n" + String.valueOf(writee));
            }
            config = Config.getDefaultConfiguration();
        }
        catch (ConfigException e) {
            FoxNap.LOGGER.error("Fox Nap configuration is invalid:\n" + String.valueOf(e));
            config = Config.getDefaultConfiguration();
        }
        return config;
    }

    private static Config getDefaultConfiguration() {
        FoxNap.LOGGER.info("Loading default Fox Nap configuration");
        Config config = new Config();
        config.numDiscs = 7;
        config.maximumNumberOfDiscs = 64;
        config.enableMaestro = true;
        return config;
    }

    private static Config fromConfigFile() throws FileNotFoundException, ConfigException {
        FoxNap.LOGGER.info("Reading Fox Nap configuration from " + String.valueOf(config_path));
        FileInputStream configReader = new FileInputStream(config_path.toFile());
        HashMap settings = new HashMap((Map)new Yaml().load(configReader));
        try {
            int numDiscs = Integer.parseInt(((Object)settings.getOrDefault("n_discs", 7)).toString());
            int maxNumDiscs = Integer.parseInt(((Object)settings.getOrDefault("max_discs", 64)).toString());
            boolean enableMaestro = Boolean.parseBoolean(((Object)settings.getOrDefault("enable_maestro", true)).toString());
            Config config = new Config();
            config.numDiscs = numDiscs;
            config.maximumNumberOfDiscs = maxNumDiscs;
            config.enableMaestro = enableMaestro;
            return config;
        }
        catch (Exception e) {
            throw new ConfigException(String.valueOf(config_path) + " is not a valid Fox Nap configuration.", e);
        }
    }

    protected void writeConfigToFile() throws ConfigException {
        FileWriter configWriter;
        try {
            configWriter = new FileWriter(config_path.toFile());
        }
        catch (IOException e) {
            throw new ConfigException("Could not open " + String.valueOf(config_path) + " for writing.", e);
        }
        LinkedHashMap<String, Constable> writeme = new LinkedHashMap<String, Constable>();
        writeme.put("n_discs", Integer.valueOf(this.numDiscs));
        if (this.maximumNumberOfDiscs != 64) {
            writeme.put("max_discs", Integer.valueOf(this.maximumNumberOfDiscs));
        }
        writeme.put("enable_maestro", Boolean.valueOf(this.enableMaestro));
        new Yaml(configFormat).dump(writeme, configWriter);
        FoxNap.LOGGER.info("Wrote Fox Nap configuration file to " + String.valueOf(config_path));
    }

    private static void writeDefaultConfigFile() throws ConfigException {
        Config.getDefaultConfiguration().writeConfigToFile();
    }

    protected static class ConfigException
    extends Exception {
        ConfigException(String message, Exception e) {
            super(message, e);
        }

        ConfigException(String message) {
            super(message);
        }
    }
}

