/*
 * Decompiled with CFR 0.152.
 */
package net.openbagtwo.foxnap.config;

import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.option.GameOptionsScreen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.option.GameOptions;
import net.minecraft.client.option.SimpleOption;
import net.minecraft.text.Text;
import net.openbagtwo.foxnap.FoxNap;
import net.openbagtwo.foxnap.config.Config;

public class ConfigScreen
extends GameOptionsScreen {
    public Config config = Config.loadConfiguration();

    public ConfigScreen(Screen previous) {
        super(previous, MinecraftClient.getInstance().options, Text.of((String)"Fox Nap"));
    }

    protected void addOptions() {
        if (this.body == null) {
            return;
        }
        this.body.addSingleOptionEntry(SimpleOption.ofBoolean((String)"Enable Maestro", (boolean)this.config.getMaestroEnabled(), value -> this.config.setMaestroEnabled((boolean)value)));
        this.body.addSingleOptionEntry(new SimpleOption("Number of Discs", SimpleOption.constantTooltip((Text)Text.of((String)"The size of the Maestro's music disc trade pool")), (optionText, value) -> GameOptions.getGenericValueText((Text)optionText, (Text)Text.of((String)String.valueOf(value))), (SimpleOption.Callbacks)new SimpleOption.ValidatingIntSliderCallbacks(0, 64, false), (Object)this.config.getNumDiscs(), value -> this.config.setNumDiscs((int)value)));
    }

    protected void initFooter() {
        this.layout.addFooter((Widget)ButtonWidget.builder((Text)Text.of((String)"Changes will apply after restart"), button -> this.close()).width(200).build());
    }

    public void removed() {
        try {
            this.config.writeConfigToFile();
        }
        catch (Config.ConfigException e) {
            FoxNap.LOGGER.error(String.valueOf(e));
        }
    }
}

