/*
 * Decompiled with CFR 0.152.
 */
package net.openbagtwo.foxnap.discs;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemGroups;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.sound.SoundEvent;
import net.minecraft.util.Identifier;
import net.minecraft.util.Rarity;
import net.openbagtwo.foxnap.FoxNap;

public class DiscRegistry {
    public static Item registerDisc(SoundEvent track) {
        return DiscRegistry.registerDisc(track, track.id().getPath());
    }

    public static Item registerDisc(SoundEvent track, String trackName) {
        Item disc = new Item(new Item.Settings().registryKey(RegistryKey.of((RegistryKey)RegistryKeys.ITEM, (Identifier)Identifier.of((String)"foxnap", (String)trackName))).translationKey("item.minecraft.music_disc_cat").maxCount(1).rarity(Rarity.RARE).jukeboxPlayable(RegistryKey.of((RegistryKey)RegistryKeys.JUKEBOX_SONG, (Identifier)track.id())));
        Registry.register((Registry)Registries.ITEM, (Identifier)Identifier.of((String)"foxnap", (String)trackName), (Object)disc);
        FoxNap.LOGGER.debug("Registered " + String.valueOf(disc));
        return disc;
    }

    private static RegistryEntry.Reference<SoundEvent> registerTrack(SoundEvent track, Identifier trackId) {
        return Registry.registerReference((Registry)Registries.SOUND_EVENT, (Identifier)trackId, (Object)track);
    }

    public static List<Item> init(int numberOfDiscs) {
        ArrayList<Item> discs = new ArrayList<Item>();
        for (int i = 1; i <= numberOfDiscs; ++i) {
            Identifier trackId = Identifier.of((String)"foxnap", (String)String.format("track_%d", i));
            SoundEvent track = new SoundEvent(trackId, Optional.of(Float.valueOf(16.0f)));
            DiscRegistry.registerTrack(track, trackId);
            Item disc = DiscRegistry.registerDisc(track);
            discs.add(disc);
            ItemGroupEvents.modifyEntriesEvent((RegistryKey)ItemGroups.TOOLS).register(entries -> entries.add((ItemConvertible)disc));
        }
        return discs;
    }

    public static List<Item> init(int numberOfDiscs, int maxNumDiscs) {
        Identifier placeholderId = Identifier.of((String)"foxnap", (String)"placeholder");
        SoundEvent placeholder = new SoundEvent(placeholderId, Optional.of(Float.valueOf(16.0f)));
        DiscRegistry.registerTrack(placeholder, placeholderId);
        int placeholderCount = 0;
        for (int i = numberOfDiscs + 1; i <= maxNumDiscs; ++i) {
            DiscRegistry.registerDisc(placeholder, String.format("track_%d", i));
            ++placeholderCount;
        }
        FoxNap.LOGGER.debug(String.format("Registered %d placeholder discs", placeholderCount));
        return DiscRegistry.init(numberOfDiscs);
    }
}

