/*
 * Decompiled with CFR 0.152.
 */
package net.openbagtwo.foxnap.instruments;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemGroups;
import net.minecraft.item.Items;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.sound.SoundEvent;
import net.minecraft.util.Identifier;
import net.openbagtwo.foxnap.FoxNap;
import net.openbagtwo.foxnap.instruments.SecretlyJustAGoatHorn;

public class InstrumentRegistry {
    private static final Map<String, Integer> INSTRUMENTS = Map.ofEntries(Map.entry("bassoon", 8), Map.entry("cello", 10), Map.entry("clarinet", 5), Map.entry("flute", 6), Map.entry("oboe", 8), Map.entry("saxophone", 4), Map.entry("trombone", 3), Map.entry("trumpet", 10), Map.entry("tuba", 5), Map.entry("viola", 9), Map.entry("violin", 5));

    public static Item registerInstrument(String instrumentName) {
        return Items.register((RegistryKey)RegistryKey.of((RegistryKey)RegistryKeys.ITEM, (Identifier)Identifier.of((String)"foxnap", (String)instrumentName)), settings -> new SecretlyJustAGoatHorn((Item.Settings)settings, InstrumentRegistry.registerInstrumentSound(instrumentName), 20 * INSTRUMENTS.get(instrumentName)), (Item.Settings)new Item.Settings());
    }

    public static SoundEvent registerInstrumentSound(String instrumentName) {
        Identifier playSoundId = Identifier.of((String)"foxnap", (String)instrumentName);
        return (SoundEvent)Registry.register((Registry)Registries.SOUND_EVENT, (Identifier)playSoundId, (Object)SoundEvent.of((Identifier)playSoundId));
    }

    public static List<Item> init() {
        ArrayList<Item> instruments = new ArrayList<Item>();
        for (String instrument : INSTRUMENTS.keySet()) {
            Item tooter = InstrumentRegistry.registerInstrument(instrument);
            ItemGroupEvents.modifyEntriesEvent((RegistryKey)ItemGroups.TOOLS).register(entries -> entries.add((ItemConvertible)tooter));
            instruments.add(tooter);
            FoxNap.LOGGER.debug("Registered " + instrument);
        }
        return instruments;
    }
}

