/*
 * Decompiled with CFR 0.152.
 */
package net.openbagtwo.foxnap.instruments;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.GoatHornItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.sound.SoundCategory;
import net.minecraft.sound.SoundEvent;
import net.minecraft.stat.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.Rarity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.event.GameEvent;

public class SecretlyJustAGoatHorn
extends GoatHornItem {
    private final SoundEvent soundEvent;
    private final int cooldown;

    public SecretlyJustAGoatHorn(Item.Settings settings, SoundEvent soundEvent, int cooldown) {
        super(settings.useItemPrefixedTranslationKey().rarity(Rarity.UNCOMMON).maxCount(1));
        this.soundEvent = soundEvent;
        this.cooldown = cooldown;
    }

    public ActionResult use(World world, PlayerEntity user, Hand hand) {
        ItemStack itemStack = user.getStackInHand(hand);
        user.setCurrentHand(hand);
        SecretlyJustAGoatHorn.playSound(world, user, this.soundEvent);
        user.getItemCooldownManager().set(itemStack, MathHelper.floor((float)this.cooldown));
        user.incrementStat(Stats.USED.getOrCreateStat((Object)this));
        return ActionResult.CONSUME;
    }

    private static void playSound(World world, PlayerEntity player, SoundEvent soundEvent) {
        world.playSoundFromEntity((Entity)player, (Entity)player, soundEvent, SoundCategory.RECORDS, 4.0f, 1.0f);
        world.emitGameEvent((RegistryEntry)GameEvent.INSTRUMENT_PLAY, player.getEntityPos(), GameEvent.Emitter.of((Entity)player));
    }

    public int getMaxUseTime(ItemStack stack, LivingEntity user) {
        return this.cooldown;
    }
}

