/*
 * Decompiled with CFR 0.152.
 */
package net.openbagtwo.foxnap.villagers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.sound.SoundEvent;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import net.minecraft.village.TradeOffers;
import net.minecraft.village.VillagerProfession;
import net.openbagtwo.foxnap.FoxNap;
import net.openbagtwo.foxnap.instruments.InstrumentRegistry;
import net.openbagtwo.foxnap.integration.LighterEnd;
import net.openbagtwo.foxnap.villagers.MusicAndArts;

public class Conductor {
    public static final SoundEvent CONDUCTOR_WORK_SOUND = InstrumentRegistry.registerInstrumentSound("condutor_baton");

    private static VillagerProfession makeConductor() {
        Identifier poi_id = Identifier.of((String)"foxnap", (String)"conductor_poi");
        PointOfInterestHelper.register((Identifier)poi_id, (int)1, (int)1, (Iterable)ImmutableSet.copyOf((Collection)Blocks.JUKEBOX.getStateManager().getStates()));
        return (VillagerProfession)Registry.register((Registry)Registries.VILLAGER_PROFESSION, (Identifier)Identifier.of((String)"foxnap", (String)"conductor"), (Object)new VillagerProfession((Text)Text.literal((String)"conductor"), entry -> entry.matchesKey(RegistryKey.of((RegistryKey)Registries.POINT_OF_INTEREST_TYPE.getKey(), (Identifier)poi_id)), entry -> entry.matchesKey(RegistryKey.of((RegistryKey)Registries.POINT_OF_INTEREST_TYPE.getKey(), (Identifier)poi_id)), ImmutableSet.of(), ImmutableSet.of(), CONDUCTOR_WORK_SOUND));
    }

    public static void init(List<Item> instruments, List<Item> records) {
        List<TradeOffers.Factory> level1Trades = Arrays.asList(MusicAndArts.BUY_TONEWOOD, MusicAndArts.sellInstrument(instruments, 1));
        List<TradeOffers.Factory> level2Trades = Arrays.asList(MusicAndArts.BUY_NOTEBLOCK, MusicAndArts.sellInstrument(instruments, 2));
        List<TradeOffers.Factory> level3Trades = Arrays.asList(MusicAndArts.BUY_SHOFAR, MusicAndArts.sellInstrument(instruments, 3));
        List<TradeOffers.Factory> level4Trades = Arrays.asList(MusicAndArts.buyMusicDisc(Arrays.asList(Items.MUSIC_DISC_13, Items.MUSIC_DISC_CAT, Items.DISC_FRAGMENT_5)), MusicAndArts.sellInstrument(instruments, 4));
        ArrayList<TradeOffers.Factory> level5Trades = new ArrayList<TradeOffers.Factory>();
        for (Item disc : records) {
            level5Trades.add(MusicAndArts.sellMusicDisc(disc));
        }
        if (FabricLoader.getInstance().isModLoaded("lighterend")) {
            level3Trades = new ArrayList<TradeOffers.Factory>(level3Trades);
            level3Trades.add(new MusicAndArts.BuyItemFromPoolForOneEmeraldFactory(LighterEnd::getTonewoods, 3, 16, 16));
            FoxNap.LOGGER.info(String.format("Integrating BetterEnd woods into %s's %s trades", "Fox Nap", "Conductor"));
            level4Trades = new ArrayList<TradeOffers.Factory>(level4Trades);
            level4Trades.add(MusicAndArts.buyMusicDisc(LighterEnd::getMusicDiscs));
            FoxNap.LOGGER.info(String.format("Integrating BetterEnd music discs into %s's %s trades", "Fox Nap", "Conductor"));
        }
        Conductor.makeConductor();
        TradeOffers.PROFESSION_TO_LEVELED_TRADE.put(RegistryKey.of((RegistryKey)RegistryKeys.VILLAGER_PROFESSION, (Identifier)Identifier.of((String)"foxnap", (String)"conductor")), TradeOffers.copyToFastUtilMap((ImmutableMap)ImmutableMap.of((Object)1, (Object)level1Trades.toArray(new TradeOffers.Factory[1]), (Object)2, (Object)level2Trades.toArray(new TradeOffers.Factory[1]), (Object)3, (Object)level3Trades.toArray(new TradeOffers.Factory[1]), (Object)4, (Object)level4Trades.toArray(new TradeOffers.Factory[1]), (Object)5, (Object)level5Trades.toArray(new TradeOffers.Factory[1]))));
        FoxNap.LOGGER.info(String.format("Registered %s's %s villager", "Fox Nap", "Conductor"));
    }
}

