/*
 * Decompiled with CFR 0.152.
 */
package net.openbagtwo.foxnap.villagers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.random.Random;
import net.minecraft.village.TradeOffer;
import net.minecraft.village.TradeOffers;
import net.minecraft.village.TradedItem;
import net.openbagtwo.foxnap.FoxNap;
import org.jetbrains.annotations.Nullable;

public class MusicAndArts
implements TradeOffers.Factory {
    private final boolean isBuy;
    private final int price;
    private final int maxUses;
    private final int xp;
    private final Supplier<List<? extends Item>> poolProvider;
    public static final List<Item> TONEWOODS = Arrays.asList(Items.STRIPPED_SPRUCE_WOOD, Items.STRIPPED_ACACIA_WOOD, Items.STRIPPED_DARK_OAK_WOOD, Items.STRIPPED_MANGROVE_WOOD);
    public static final TradeOffers.Factory BUY_TONEWOOD = new BuyItemFromPoolForOneEmeraldFactory(() -> TONEWOODS, 4, 16, 3);
    public static final TradeOffers.Factory BUY_NOTEBLOCK = new BuyItemFromPoolForOneEmeraldFactory(() -> Collections.singletonList(Items.NOTE_BLOCK), 2, 12, 15);
    public static final TradeOffers.Factory BUY_SHOFAR = new BuyItemFromPoolForOneEmeraldFactory(() -> Collections.singletonList(Items.GOAT_HORN), 1, 8, 20);
    private static final int[] xpMap = new int[]{2, 5, 10, 15, 20};

    private MusicAndArts(Supplier<List<? extends Item>> poolProvider, int price, int maxUses, int xp) {
        this.poolProvider = poolProvider;
        if (price > 0) {
            this.price = price;
            this.isBuy = true;
        } else if (price < 0) {
            this.price = -price;
            this.isBuy = false;
        } else {
            FoxNap.LOGGER.error("Sorry, PooledTradeFactories do not support acts of charity. This PooledTradeFactory will do nothing.");
            this.isBuy = false;
            this.price = 0;
        }
        this.maxUses = maxUses;
        this.xp = xp;
    }

    @Nullable
    public TradeOffer create(ServerWorld world, Entity entity, Random random) {
        List<? extends Item> itemPool = this.poolProvider.get();
        if (this.price == 0 || itemPool.isEmpty()) {
            return null;
        }
        Item selectedItem = itemPool.get(random.nextInt(itemPool.size()));
        if (this.isBuy) {
            return new TradeOffer(new TradedItem((ItemConvertible)selectedItem, this.price), new ItemStack((ItemConvertible)Items.EMERALD), this.maxUses, this.xp, 0.05f);
        }
        return new TradeOffer(new TradedItem((ItemConvertible)Items.EMERALD, this.price), new ItemStack((ItemConvertible)selectedItem.asItem()), this.maxUses, this.xp, 0.05f);
    }

    public static TradeOffers.Factory buyMusicDisc(Supplier<List<? extends Item>> discProvider) {
        return new BuyItemFromPoolForOneEmeraldFactory(discProvider, 1, 8, 30);
    }

    public static TradeOffers.Factory buyMusicDisc(List<Item> musicDiscs) {
        return MusicAndArts.buyMusicDisc(() -> musicDiscs);
    }

    public static TradeOffers.Factory sellInstrument(List<Item> instruments, int level) {
        return new SellOneItemFromPoolFactory(() -> instruments, 12, 12, xpMap[level - 1]);
    }

    public static TradeOffers.Factory sellMusicDisc(List<Item> discs) {
        return new SellOneItemFromPoolFactory(() -> discs, 32, 3, 30);
    }

    public static TradeOffers.Factory sellMusicDisc(Item disc) {
        return new SellOneItemFromPoolFactory(() -> Collections.singletonList(disc), 32, 3, 30);
    }

    public static class BuyItemFromPoolForOneEmeraldFactory
    extends MusicAndArts {
        public BuyItemFromPoolForOneEmeraldFactory(Supplier<List<? extends Item>> poolProvider, int price, int maxUses, int xp) {
            super(poolProvider, Math.max(price, 0), maxUses, xp);
        }
    }

    public static class SellOneItemFromPoolFactory
    extends MusicAndArts {
        public SellOneItemFromPoolFactory(Supplier<List<? extends Item>> poolProvider, int price, int maxUses, int xp) {
            super(poolProvider, -Math.max(price, 0), maxUses, xp);
        }
    }
}

