package net.openbagtwo.foxnap.discs;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.openbagtwo.foxnap.FoxNap;

/**
 * Dynamic registry of music discs created by this mod
 */
public class DiscRegistry {


  /**
   * Create a new music disc, and register the item and its sound event
   *
   * @param track The sound event (read: jukebox song) to tie to the disc
   * @return the fully instantiated and registered music disc
   */
  public static class_1792 registerDisc(class_3414 track) {
    return registerDisc(track, track.comp_3319().method_12832());
  }

  /**
   * Create a new music disc, and register the item and its sound event
   *
   * @param track     The sound event (read: jukebox song) to tie to the disc
   * @param trackName The identifier for the music disc (if distinct from the track ID)
   * @return the fully instantiated and registered music disc
   */
  public static class_1792 registerDisc(class_3414 track, String trackName) {
    class_1792 disc = new class_1792(
        new class_1792.class_1793()
            .method_63686(
                class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(FoxNap.MOD_ID, trackName))
            )
            .method_63684("item.minecraft.music_disc_cat")
            .method_7889(1)
            .method_7894(class_1814.field_8903)
            .method_60745(
                class_5321.method_29179(class_7924.field_52176, track.comp_3319())
            )
    );
    class_2378.method_10230(class_7923.field_41178, class_2960.method_60655(FoxNap.MOD_ID, trackName), disc);

    FoxNap.LOGGER.debug("Registered " + disc);
    return disc;
  }

  private static class_6880.class_6883<class_3414> registerTrack(class_3414 track,
      class_2960 trackId) {
    return class_2378.method_47985(class_7923.field_41172, trackId, track);
  }

  /**
   * Create and register a procedurally-generated set of music discs named track_i (each registered
   * with a sound event named track_i and emitting a comparator signal of strength i), starting at i
   * = 1
   *
   * @param numberOfDiscs The number of tracks that will be made available for use on the server
   *                      (read: offered by The Maestro).
   * @return A list of fully instantiated and registered music discs
   */
  public static List<class_1792> init(int numberOfDiscs) {
    ArrayList<class_1792> discs = new ArrayList<>();
    for (int i = 1; i <= numberOfDiscs; i++) {
      class_2960 trackId = class_2960.method_60655(FoxNap.MOD_ID, String.format("track_%d", i));
      class_3414 track = new class_3414(trackId, Optional.of(16.0f));
      registerTrack(track, trackId);
      class_1792 disc = registerDisc(track);
      discs.add(disc);
      ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(entries -> entries.method_45421(disc));
    }
    return discs;
  }

  /**
   * In addition to the procedurally-generated set of usable music discs, also generate extra
   * dummy/placeholder discs to prevent client/server conflicts
   *
   * @param numberOfDiscs The number of discs that will actually be available for use
   * @param maxNumDiscs   The maximum number of discs (the number of disc items that will be created
   *                      in the namespace)
   * @return The list of discs that should actually be available for use
   */
  public static List<class_1792> init(int numberOfDiscs, int maxNumDiscs) {
    class_2960 placeholderId = class_2960.method_60655(FoxNap.MOD_ID, "placeholder");
    class_3414 placeholder = new class_3414(placeholderId, Optional.of(16.0f));

    registerTrack(placeholder, placeholderId);

    int placeholderCount = 0;
    for (int i = numberOfDiscs + 1; i <= maxNumDiscs; i++) {
      registerDisc(placeholder, String.format("track_%d", i));
      placeholderCount++;
    }
    FoxNap.LOGGER.debug(String.format("Registered %d placeholder discs", placeholderCount));

    return init(numberOfDiscs);
  }
}
