package net.openbagtwo.foxnap.instruments;

import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.openbagtwo.foxnap.FoxNap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Registry of all instruments created by this mod
 */
public class InstrumentRegistry {

  private static final Map<String, Integer> INSTRUMENTS = Map.ofEntries(
      Map.entry("bassoon", 8),
      Map.entry("cello", 10),
      Map.entry("clarinet", 5),
      Map.entry("flute", 6),
      Map.entry("oboe", 8),
      Map.entry("saxophone", 4),
      Map.entry("trombone", 3),
      Map.entry("trumpet", 10),
      Map.entry("tuba", 5),
      Map.entry("viola", 9),
      Map.entry("violin", 5)
  );


  /**
   * Create a new instrument, and register the item and its sound event
   *
   * @param instrumentName the name of the instrument (which should also be the name of its sound
   *                       event)
   * @return the fully instantiated and registered instrument
   */
  public static class_1792 registerInstrument(String instrumentName) {
    return class_1802.method_51348(
        class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(FoxNap.MOD_ID, instrumentName)),
        settings -> new SecretlyJustAGoatHorn(
            settings,
            registerInstrumentSound(instrumentName),
            20 * INSTRUMENTS.get(instrumentName)
        ),
        new class_1793()
    );
  }

  public static class_3414 registerInstrumentSound(String instrumentName) {
    class_2960 playSoundId = class_2960.method_60655(FoxNap.MOD_ID, instrumentName);
    return class_2378.method_10230(class_7923.field_41172, playSoundId, class_3414.method_47908(playSoundId));
  }

  /**
   * Create and register all instruments defined by this mod
   *
   * @return A list of fully instantiated and registered instruments
   */
  public static List<class_1792> init() {
    ArrayList<class_1792> instruments = new ArrayList<>();
    for (String instrument : INSTRUMENTS.keySet()) {
      class_1792 tooter = registerInstrument(instrument);
      ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(entries -> entries.method_45421(tooter));
      instruments.add(tooter);
      FoxNap.LOGGER.debug("Registered " + instrument);
    }
    return instruments;


  }
}
