package net.openbagtwo.foxnap.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

/**
 * Tonewood and music disc integration for the LighterEnd mod
 */
public class LighterEnd {

  public static final String MOD_ID = "lighterend";

  private static final List<String> tonewoods = Arrays.asList(
      "umbrella",
      "end_lotus",
      "mossy_glowshroom",
      "lacugrove",
      "dragon",
      "helix",
      "jellyshroom",
      "lucernia"
  );

  private static final List<String> tracks = Arrays.asList(
      "strange_and_alien",
      "grasping_at_stars",
      "endseeker",
      "eo_dracona"
  );

  /**
   * @return a list of stripped woods from the mod that seem like would make for good tonewood
   */
  public static List<class_1792> getTonewoods() {
    ArrayList<class_1792> tonewoodItemList = new ArrayList<>();
    for (String woodType : tonewoods) {

      if (class_7923.field_41178.method_10250(
          class_2960.method_60655(MOD_ID, woodType + "_stripped_wood")
      )) {
        tonewoodItemList.add(class_7923.field_41178.method_63535(
            class_2960.method_60655(MOD_ID, woodType + "_stripped_wood")));
      }
    }
    return tonewoodItemList;
  }

  /**
   * @return the list of music discs that the mod makes available as end city loot
   */
  public static List<class_1792> getMusicDiscs() {
    ArrayList<class_1792> discList = new ArrayList<>();
    for (String end_disc_name : tracks) {
      if (class_7923.field_41178.method_10250(
          class_2960.method_60655(MOD_ID, "music_disc_" + end_disc_name)
      )) {
        discList.add(class_7923.field_41178.method_63535(
            class_2960.method_60655(MOD_ID, "music_disc_" + end_disc_name)
        ));
      }
    }
    return discList;
  }
}
