package net.openbagtwo.foxnap.villagers;

import static net.openbagtwo.foxnap.FoxNap.LOGGER;
import static net.openbagtwo.foxnap.FoxNap.MOD_ID;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.openbagtwo.foxnap.FoxNap;
import net.openbagtwo.foxnap.instruments.InstrumentRegistry;
import net.openbagtwo.foxnap.integration.LighterEnd;

/**
 * The villager who will sell you all these goodies
 */
public class Conductor {

  public static final class_3414 CONDUCTOR_WORK_SOUND = InstrumentRegistry.registerInstrumentSound(
      "condutor_baton");

  private static class_3852 makeConductor() {

    class_2960 poi_id = class_2960.method_60655(MOD_ID, "conductor_poi");
    PointOfInterestHelper.register(poi_id, 1, 1,
        // hoping this is in chunks?
        ImmutableSet.copyOf(class_2246.field_10223.method_9595().method_11662())
    );

    return class_2378.method_10230(
        class_7923.field_41195,
        class_2960.method_60655(MOD_ID, "conductor"),
        new class_3852(
            class_2561.method_43470("conductor"),
            entry -> entry.method_40225(
                class_5321.method_29179(class_7923.field_41128.method_46765(), poi_id)
            ),
            entry -> entry.method_40225(
                class_5321.method_29179(class_7923.field_41128.method_46765(), poi_id)
            ),
            ImmutableSet.of(),
            ImmutableSet.of(),
            CONDUCTOR_WORK_SOUND
        )
    );
  }


  /**
   * Register FoxNap's custom villager profession and all their trades.
   *
   * @param instruments The list of custom instruments created by this mod, as returned by
   *                    InstrumentRegistry.init()
   * @param records     The list of custom records created by this mod, as returned by
   *                    DiscRegistry.init()
   */
  public static void init(List<class_1792> instruments, List<class_1792> records) {

    List<class_3853.class_1652> level1Trades = Arrays.asList(
        MusicAndArts.BUY_TONEWOOD,
        MusicAndArts.sellInstrument(instruments, 1)
    );

    List<class_3853.class_1652> level2Trades = Arrays.asList(
        MusicAndArts.BUY_NOTEBLOCK,
        MusicAndArts.sellInstrument(instruments, 2)
    );

    List<class_3853.class_1652> level3Trades = Arrays.asList(
        MusicAndArts.BUY_SHOFAR,
        MusicAndArts.sellInstrument(instruments, 3)
    );

    List<class_3853.class_1652> level4Trades = Arrays.asList(
        MusicAndArts.buyMusicDisc(
            Arrays.asList(
                class_1802.field_8144,
                class_1802.field_8075,
                class_1802.field_38974
            )
        ),
        MusicAndArts.sellInstrument(instruments, 4)
    );

    List<class_3853.class_1652> level5Trades = new ArrayList<>();
    for (class_1792 disc : records) {
      level5Trades.add(MusicAndArts.sellMusicDisc(disc));
    }

    if (FabricLoader.getInstance().isModLoaded(LighterEnd.MOD_ID)) {
      level3Trades = new ArrayList<>(level3Trades);
      level3Trades.add(
          new MusicAndArts.BuyItemFromPoolForOneEmeraldFactory(
              LighterEnd::getTonewoods,
              3,
              16,
              16
          )
      );
      LOGGER.info(
          String.format(
              "Integrating BetterEnd woods into %s's %s trades",
              FoxNap.MOD_NAME,
              "Conductor"
          )
      );

      level4Trades = new ArrayList<>(level4Trades);
      level4Trades.add(MusicAndArts.buyMusicDisc(LighterEnd::getMusicDiscs));
      LOGGER.info(
          String.format(
              "Integrating BetterEnd music discs into %s's %s trades",
              FoxNap.MOD_NAME,
              "Conductor"
          )
      );
    }

    makeConductor();

    class_3853.field_17067.put(
        class_5321.method_29179(class_7924.field_41234, class_2960.method_60655(MOD_ID, "conductor")),
        class_3853.method_16928(ImmutableMap.of(
                1, level1Trades.toArray(new class_3853.class_1652[1]),
                2, level2Trades.toArray(new class_3853.class_1652[1]),
                3, level3Trades.toArray(new class_3853.class_1652[1]),
                4, level4Trades.toArray(new class_3853.class_1652[1]),
                5, level5Trades.toArray(new class_3853.class_1652[1])
            )
        )
    );

    LOGGER.info(String.format("Registered %s's %s villager", FoxNap.MOD_NAME, "Conductor"));
  }
}
