/*
 * Decompiled with CFR 0.152.
 */
package com.tiji.media;

import com.tiji.media.ApiCalls;
import com.tiji.media.MediaConfig;
import com.tiji.media.NowPlayingScreen;
import com.tiji.media.SetupScreen;
import com.tiji.media.SongData;
import com.tiji.media.SongDataExtractor;
import com.tiji.media.SongToast;
import com.tiji.media.WebGuideServer;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.CottonClientScreen;
import java.io.IOException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class MediaClient
implements ClientModInitializer {
    public static final MediaConfig CONFIG = new MediaConfig();
    private static final class_304 SETUP_KEY = new class_304("key.media.general", 90, "key.categories.misc");
    public static int tickCount = 0;
    public static NowPlayingScreen nowPlayingScreen = null;

    public void onInitializeClient() {
        CONFIG.generate();
        KeyBindingHelper.registerKeyBinding((class_304)SETUP_KEY);
        if (MediaClient.isNotSetup()) {
            try {
                WebGuideServer.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ApiCalls.refreshAccessToken();
        }
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> SongDataExtractor.reloadData(true, () -> {}, () -> {}, () -> {}));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (SETUP_KEY.method_1436()) {
                if (MediaClient.isNotSetup()) {
                    client.method_1507((class_437)new CottonClientScreen((GuiDescription)new SetupScreen()));
                    continue;
                }
                nowPlayingScreen = new NowPlayingScreen();
                nowPlayingScreen.updateCoverImage();
                nowPlayingScreen.updateNowPlaying();
                client.method_1507((class_437)new CottonClientScreen((GuiDescription)nowPlayingScreen));
            }
            if (!MediaClient.isNotSetup() && tickCount % 10 == 0) {
                if (nowPlayingScreen != null) {
                    SongDataExtractor.reloadData(false, nowPlayingScreen::updateStatus, nowPlayingScreen::updateNowPlaying, () -> {
                        nowPlayingScreen.updateCoverImage();
                        if (CONFIG.shouldShowToasts()) {
                            new SongToast(SongData.coverImage, SongData.artist, SongData.title).show(class_310.method_1551().method_1566());
                        }
                    });
                }
                if ((double)CONFIG.lastRefresh() + 1800000.0 < (double)System.currentTimeMillis()) {
                    ApiCalls.refreshAccessToken();
                }
            }
            ++tickCount;
        });
    }

    public static boolean isNotSetup() {
        return CONFIG.clientId().isEmpty() || CONFIG.authToken().isEmpty() || CONFIG.refreshToken().isEmpty();
    }
}

