/*
 * Decompiled with CFR 0.152.
 */
package com.tiji.media;

import com.tiji.media.ApiCalls;
import com.tiji.media.Media;
import com.tiji.media.MediaClient;
import com.tiji.media.SongData;
import com.tiji.media.widgets.borderlessButtonWidget;
import com.tiji.media.widgets.clickableSprite;
import com.tiji.media.widgets.progressWidget;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WSprite;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class NowPlayingScreen
extends LightweightGuiDescription {
    public WLabel songName = new WLabel((class_2561)class_2561.method_43471((String)"ui.media.nothing_playing"));
    public WLabel artistName = new WLabel((class_2561)class_2561.method_43471((String)"ui.media.unknown_artist"));
    public progressWidget progressBar = new progressWidget(0, 100, Axis.HORIZONTAL);
    public WLabel durationLabel = new WLabel((class_2561)class_2561.method_43471((String)"ui.media.unknown_duration"));
    public WLabel currentTimeLabel = new WLabel((class_2561)class_2561.method_43471((String)"ui.media.unknown_time"));
    public borderlessButtonWidget playPauseButton = new borderlessButtonWidget((class_2561)class_2561.method_43470((String)"\u23f8"));
    public WSprite albumCover = new WSprite(class_2960.method_60655((String)"media", (String)"ui/nothing.png"));

    public NowPlayingScreen() {
        RootPanel root = new RootPanel();
        root.setSize(300, 200);
        root.setInsets(Insets.NONE);
        root.add((WWidget)this.albumCover, 100, 10, 100, 100);
        root.add(new clickableSprite(class_2960.method_60655((String)"media", (String)"ui/attribution.png")).setOnClick(() -> {
            if (SongData.songURI == null) {
                return;
            }
            class_156.method_668().method_673(SongData.songURI);
        }), 270, 10);
        this.songName = this.songName.setHorizontalAlignment(HorizontalAlignment.CENTER);
        root.add((WWidget)this.songName, 100, 120, 100, 20);
        this.artistName = this.artistName.setHorizontalAlignment(HorizontalAlignment.CENTER);
        root.add((WWidget)this.artistName, 100, 135, 100, 20);
        root.add((WWidget)new borderlessButtonWidget((class_2561)class_2561.method_43470((String)"\u23ee")).setOnClick(ApiCalls::previousTrack), 120, 150, 20, 20);
        this.playPauseButton.setOnClick(() -> {
            if (SongData.Id.isEmpty()) {
                return;
            }
            SongData.isPlaying = !SongData.isPlaying;
            ApiCalls.playPause(SongData.isPlaying);
            this.playPauseButton.setLabel(class_2561.method_30163((String)(SongData.isPlaying ? "\u23f8" : "\u23f9")));
        });
        root.add((WWidget)this.playPauseButton, 140, 150, 20, 20);
        root.add((WWidget)new borderlessButtonWidget((class_2561)class_2561.method_43470((String)"\u23ed")).setOnClick(ApiCalls::nextTrack), 160, 150, 20, 20);
        this.currentTimeLabel = this.currentTimeLabel.setHorizontalAlignment(HorizontalAlignment.LEFT);
        root.add((WWidget)this.currentTimeLabel, 10, 160, 60, 20);
        this.progressBar.setMaxValue(300);
        root.add((WWidget)this.progressBar, 10, 175, 280, 10);
        this.durationLabel = this.durationLabel.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        root.add((WWidget)this.durationLabel, 230, 160, 60, 20);
        root.validate((GuiDescription)this);
        this.setRootPanel((WPanel)root);
    }

    public void updateStatus() {
        if (SongData.Id.isEmpty()) {
            return;
        }
        if (this.progressBar.allowUpdateProgress) {
            if (SongData.progressValue == null) {
                Media.LOGGER.warn("Progress value is null");
            } else {
                this.progressBar.setValue((int)Math.round(SongData.progressValue * 300.0));
            }
        }
        this.currentTimeLabel.setText(class_2561.method_30163((String)SongData.progressLabel));
        this.playPauseButton.setLabel(class_2561.method_30163((String)(SongData.isPlaying ? "\u23f8" : "\u23f9")));
    }

    public void updateNowPlaying() {
        if (SongData.Id.isEmpty()) {
            this.nothingPlaying();
            return;
        }
        Media.LOGGER.info(SongData.tostring());
        this.songName.setText(class_2561.method_30163((String)SongData.title));
        this.artistName.setText(class_2561.method_30163((String)SongData.artist));
        this.durationLabel.setText(class_2561.method_30163((String)SongData.durationLabel));
        this.updateCoverImage();
        this.updateStatus();
    }

    public void nothingPlaying() {
        this.songName.setText((class_2561)class_2561.method_43471((String)"ui.media.nothing_playing"));
        this.artistName.setText((class_2561)class_2561.method_43471((String)"ui.media.unknown_artist"));
        this.durationLabel.setText((class_2561)class_2561.method_43471((String)"ui.media.unknown_duration"));
        this.updateCoverImage();
        this.progressBar.setValue(0);
        this.currentTimeLabel.setText((class_2561)class_2561.method_43471((String)"ui.media.unknown_time"));
    }

    public void updateCoverImage() {
        this.albumCover.setImage(SongData.coverImage);
    }

    @Environment(value=EnvType.CLIENT)
    private static class RootPanel
    extends WPlainPanel {
        private RootPanel() {
        }

        public void onHidden() {
            MediaClient.nowPlayingScreen = null;
        }
    }
}

