/*
 * Decompiled with CFR 0.152.
 */
package com.tiji.media;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.tiji.media.ApiCalls;
import com.tiji.media.Media;
import com.tiji.media.MediaClient;
import com.tiji.media.SongDataExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class WebGuideServer {
    public static HttpServer server;

    public static void start() throws IOException {
        server = HttpServer.create(new InetSocketAddress(25566), 0);
        server.createContext("/callback", new callbackHandler());
        server.createContext("/data", new dataHandler());
        server.createContext("/", new rootHandler());
        server.setExecutor(null);
        server.start();
    }

    public static void stop() {
        server.stop(0);
    }

    @Environment(value=EnvType.CLIENT)
    private static class callbackHandler
    implements HttpHandler {
        private callbackHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String response;
            int length;
            String Code = exchange.getRequestURI().getQuery().split("=")[1];
            MediaClient.CONFIG.accessToken(Code);
            Media.LOGGER.info("Callback Received: {}", (Object)Code);
            String filepath = switch (class_310.method_1551().method_1526().method_4669()) {
                case "ko_kr" -> "/allset/ko_kr.html";
                default -> "/allset/en_us.html";
            };
            try (InputStream in = WebGuideServer.class.getResourceAsStream(filepath);){
                if (in == null) {
                    throw new RuntimeException("Guide file is not found!");
                }
                byte[] file = in.readAllBytes();
                length = file.length;
                response = new String(file);
            }
            exchange.getResponseHeaders().set("Content-Type", "text/html");
            exchange.sendResponseHeaders(200, length);
            OutputStream os = exchange.getResponseBody();
            os.write(response.getBytes());
            os.close();
            ApiCalls.convertAccessToken(Code);
            class_310.method_1551().execute(() -> class_310.method_1551().method_1507(null));
            SongDataExtractor.reloadData(true, () -> {}, () -> {}, () -> {});
            Media.LOGGER.info("Stopping Guide Server...");
            WebGuideServer.stop();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class dataHandler
    implements HttpHandler {
        private dataHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            MediaClient.CONFIG.clientSecret(exchange.getRequestHeaders().getFirst("Secret"));
            MediaClient.CONFIG.clientId(exchange.getRequestHeaders().getFirst("Client-Id"));
            Media.LOGGER.info("Client Information Received");
            String response = "Received";
            exchange.sendResponseHeaders(200, response.length());
            OutputStream os = exchange.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class rootHandler
    implements HttpHandler {
        private rootHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String response;
            int length;
            String filepath = switch (class_310.method_1551().method_1526().method_4669()) {
                case "ko_kr" -> "/guide/ko_kr.html";
                default -> "/guide/en_us.html";
            };
            try (InputStream in = WebGuideServer.class.getResourceAsStream(filepath);){
                if (in == null) {
                    throw new RuntimeException("Guide file is not found!");
                }
                byte[] file = in.readAllBytes();
                length = file.length;
                response = new String(file);
            }
            exchange.getResponseHeaders().set("Content-Type", "text/html");
            exchange.sendResponseHeaders(200, length);
            OutputStream os = exchange.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }
    }
}

