/*
 * Decompiled with CFR 0.152.
 */
package com.tiji.media;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.tiji.media.Media;
import com.tiji.media.MediaClient;
import com.tiji.media.WebGuideServer;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

@Environment(value=EnvType.CLIENT)
public class ApiCalls {
    public static void convertAccessToken(String accessToken) {
        ApiCalls.call("https://accounts.spotify.com/api/token?grant_type=authorization_code&code=" + accessToken + "&redirect_uri=http://127.0.0.1:25566/callback", ApiCalls.getAuthorizationHeader(), "application/x-www-form-urlencoded", body -> {
            JsonObject data = (JsonObject)new Gson().fromJson((String)body.body(), JsonObject.class);
            if (!data.get("scope").getAsString().equals("user-modify-playback-state user-read-playback-state user-read-currently-playing")) {
                return;
            }
            MediaClient.CONFIG.authToken(data.get("access_token").getAsString());
            MediaClient.CONFIG.refreshToken(data.get("refresh_token").getAsString());
            MediaClient.CONFIG.lastRefresh(System.currentTimeMillis());
            Media.LOGGER.info("Successfully converted access token");
        }, "POST");
    }

    public static void refreshAccessToken() {
        ApiCalls.call("https://accounts.spotify.com/api/token?grant_type=refresh_token&refresh_token=" + MediaClient.CONFIG.refreshToken(), ApiCalls.getAuthorizationHeader(), "application/x-www-form-urlencoded", body -> {
            JsonObject data = (JsonObject)new Gson().fromJson((String)body.body(), JsonObject.class);
            if (data.has("error")) {
                Media.LOGGER.warn("Failed to refresh access token; Normally caused when developer app is deleted. {}: {}", (Object)data.get("error"), (Object)data.get("error_description"));
                MediaClient.CONFIG.reset();
                try {
                    WebGuideServer.start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            MediaClient.CONFIG.authToken(data.get("access_token").getAsString());
            if (data.has("refresh_token")) {
                MediaClient.CONFIG.refreshToken(data.get("refresh_token").getAsString());
            }
            MediaClient.CONFIG.lastRefresh(System.currentTimeMillis());
        }, "POST");
    }

    public static void getNowPlayingTrack(Consumer<JsonObject> callback) {
        ApiCalls.call("https://api.spotify.com/v1/me/player", ApiCalls.getAuthorizationCode(), null, body -> callback.accept((JsonObject)new Gson().fromJson((String)body.body(), JsonObject.class)), "GET");
    }

    public static void setPlaybackLoc(int position_ms) {
        ApiCalls.call("https://api.spotify.com/v1/me/player/seek?position_ms=" + position_ms, ApiCalls.getAuthorizationCode(), null, body -> {}, "PUT");
    }

    public static void playPause(boolean state) {
        String uri = state ? "https://api.spotify.com/v1/me/player/play" : "https://api.spotify.com/v1/me/player/pause";
        ApiCalls.call(uri, ApiCalls.getAuthorizationCode(), null, body -> {}, "PUT");
    }

    public static void nextTrack() {
        ApiCalls.call("https://api.spotify.com/v1/me/player/next", ApiCalls.getAuthorizationCode(), null, body -> {}, "POST");
    }

    public static void previousTrack() {
        ApiCalls.call("https://api.spotify.com/v1/me/player/previous", ApiCalls.getAuthorizationCode(), null, body -> {}, "POST");
    }

    public static void getUserName(Consumer<String> consumer) {
        ApiCalls.call("https://api.spotify.com/v1/me", ApiCalls.getAuthorizationCode(), null, body -> {
            String name = ((JsonObject)new Gson().fromJson((String)body.body(), JsonObject.class)).get("display_name").getAsString();
            consumer.accept(name);
        }, "GET");
    }

    private static void call(String endpoint, String Authorization, String ContentType, Consumer<HttpResponse<String>> consumer, String method) {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(URI.create(endpoint)).timeout(Duration.ofSeconds(10L)).header("Authorization", Authorization);
        if (ContentType != null) {
            request.header("Content-Type", ContentType);
        }
        request = switch (method) {
            case "GET" -> request.GET();
            case "POST" -> request.POST(HttpRequest.BodyPublishers.ofString(""));
            case "PUT" -> request.PUT(HttpRequest.BodyPublishers.ofString(""));
            default -> request;
        };
        ((CompletableFuture)client.sendAsync(request.build(), HttpResponse.BodyHandlers.ofString()).exceptionally(e -> {
            Media.LOGGER.error("Failed to call API: {}", (Object)e.getMessage());
            return null;
        })).thenAccept(stringHttpResponse -> {
            String body = (String)stringHttpResponse.body();
            JsonObject data = (JsonObject)new Gson().fromJson(body, JsonObject.class);
            if (data.has("reason") && data.get("reason").getAsString().equals("PREMIUM_REQUIRED")) {
                class_310.method_1551().method_1566().method_1999((class_368)new class_370(new class_370.class_9037(), (class_2561)class_2561.method_43471((String)"ui.media.premium_required.title"), (class_2561)class_2561.method_43471((String)"ui.media.premium_required.message")));
            }
            try {
                consumer.accept((HttpResponse<String>)stringHttpResponse);
            }
            catch (Exception e) {
                Media.LOGGER.error("Failed to consume API response: ");
                e.printStackTrace();
            }
        });
    }

    private static String getAuthorizationHeader() {
        String clientId = MediaClient.CONFIG.clientId();
        String clientSecret = MediaClient.CONFIG.clientSecret();
        String encoded = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
        return "Basic " + encoded;
    }

    private static String getAuthorizationCode() {
        return "Bearer " + MediaClient.CONFIG.authToken();
    }
}

