/*
 * Decompiled with CFR 0.152.
 */
package com.tiji.media;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class MediaConfig {
    private String clientId = "";
    private String clientSecret = "";
    private String accessToken = "";
    private String authToken = "";
    private String refreshToken = "";
    private long lastRefresh = 0L;
    private boolean shouldShowToasts = true;

    public String clientId() {
        return this.clientId;
    }

    public void clientId(String value) {
        this.clientId = value;
        this.writeToFile();
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public void clientSecret(String value) {
        this.clientSecret = value;
        this.writeToFile();
    }

    public String accessToken() {
        return this.accessToken;
    }

    public void accessToken(String value) {
        this.accessToken = value;
        this.writeToFile();
    }

    public String authToken() {
        return this.authToken;
    }

    public void authToken(String value) {
        this.authToken = value;
        this.writeToFile();
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public void refreshToken(String value) {
        this.refreshToken = value;
        this.writeToFile();
    }

    public long lastRefresh() {
        return this.lastRefresh;
    }

    public void lastRefresh(long value) {
        this.lastRefresh = value;
        this.writeToFile();
    }

    public boolean shouldShowToasts() {
        return this.shouldShowToasts;
    }

    public void shouldShowToasts(boolean value) {
        this.shouldShowToasts = value;
        this.writeToFile();
    }

    public void generate() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("media.json");
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                String json = Files.readString(configPath);
                JsonObject config = (JsonObject)new Gson().fromJson(json, JsonObject.class);
                this.clientId = config.get("clientId").getAsString();
                this.clientSecret = config.get("clientSecret").getAsString();
                this.accessToken = config.get("accessToken").getAsString();
                this.authToken = config.get("authToken").getAsString();
                this.refreshToken = config.get("refreshToken").getAsString();
                this.lastRefresh = config.get("lastRefresh").getAsLong();
                this.shouldShowToasts = config.get("shouldShowToasts").getAsBoolean();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.writeToFile(false);
        }
    }

    public void writeToFile(boolean delete) {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("media.json");
        JsonObject config = new JsonObject();
        config.addProperty("clientId", this.clientId);
        config.addProperty("clientSecret", this.clientSecret);
        config.addProperty("accessToken", this.accessToken);
        config.addProperty("authToken", this.authToken);
        config.addProperty("refreshToken", this.refreshToken);
        config.addProperty("lastRefresh", (Number)this.lastRefresh);
        config.addProperty("shouldShowToasts", Boolean.valueOf(this.shouldShowToasts));
        try {
            Files.write(configPath, new Gson().toJson((JsonElement)config).getBytes(), delete ? StandardOpenOption.TRUNCATE_EXISTING : StandardOpenOption.CREATE_NEW);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToFile() {
        this.writeToFile(true);
    }

    public void reset() {
        this.lastRefresh(0L);
        this.clientId("");
        this.clientSecret("");
        this.accessToken("");
        this.authToken("");
        this.refreshToken("");
    }
}

