/*
 * Decompiled with CFR 0.152.
 */
package com.tiji.media;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiji.media.ApiCalls;
import com.tiji.media.SongData;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SongDataExtractor {
    private static final ArrayList<class_2960> loadedCover = new ArrayList();

    public static String getName(JsonObject trackObj) {
        return trackObj.getAsJsonObject("item").get("name").getAsString();
    }

    public static String getArtist(JsonObject trackObj) {
        StringBuilder artists = new StringBuilder();
        for (JsonElement artist : trackObj.getAsJsonObject("item").getAsJsonArray("artists")) {
            artists.append(artist.getAsJsonObject().get("name").getAsString()).append(", ");
        }
        artists.setLength(artists.length() - 2);
        return artists.toString();
    }

    public static String getId(JsonObject trackObj) {
        return trackObj.getAsJsonObject("item").get("id").getAsString().toLowerCase();
    }

    public static URI getSpotifyLink(JsonObject trackObj) {
        return URI.create(trackObj.getAsJsonObject("item").getAsJsonObject("external_urls").get("spotify").getAsString());
    }

    public static class_2960 getAlbumCover(JsonObject trackObj) {
        try {
            class_2960 id = class_2960.method_60655((String)"media", (String)SongDataExtractor.getId(trackObj));
            if (loadedCover.contains(id)) {
                return id;
            }
            loadedCover.add(id);
            int wantedSize = 100 * (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
            int closest = Integer.MAX_VALUE;
            JsonArray images = trackObj.getAsJsonObject("item").getAsJsonObject("album").getAsJsonArray("images");
            String closestUrl = images.get(0).getAsJsonObject().get("url").getAsString();
            for (int i = 0; i < images.size(); ++i) {
                int size = images.get(i).getAsJsonObject().get("height").getAsInt();
                if (closest <= size || size < wantedSize) continue;
                closest = size;
                closestUrl = images.get(i).getAsJsonObject().get("url").getAsString();
            }
            InputStream albumCoverUrl = URI.create(closestUrl).toURL().openStream();
            BufferedImage jpegImage = ImageIO.read(albumCoverUrl);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)jpegImage, "png", outputStream);
            ByteArrayInputStream imageStream = new ByteArrayInputStream(outputStream.toByteArray());
            class_1011 image = class_1011.method_4309((InputStream)imageStream);
            class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(() -> ((class_2960)id).toString(), image)));
            return id;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static double getDuration(JsonObject trackObj) {
        return trackObj.get("progress_ms").getAsDouble() / trackObj.getAsJsonObject("item").get("duration_ms").getAsDouble();
    }

    public static String getDurationLabel(JsonObject trackObj) {
        int duration = trackObj.getAsJsonObject("item").get("duration_ms").getAsInt();
        Integer minutes_duration = (duration /= 1000) / 60;
        Integer seconds_duration = duration % 60;
        return String.format("%02d:%02d", minutes_duration, seconds_duration);
    }

    public static String getProgressLabel(JsonObject trackObj) {
        int progress = trackObj.get("progress_ms").getAsInt();
        Integer minutes_progress = (progress /= 1000) / 60;
        Integer seconds_progress = progress % 60;
        return String.format("%02d:%02d", minutes_progress, seconds_progress);
    }

    public static boolean isPlaying(JsonObject trackObj) {
        return trackObj.get("is_playing").getAsBoolean();
    }

    public static int getMaxDuration(JsonObject trackObj) {
        return trackObj.getAsJsonObject("item").get("duration_ms").getAsInt();
    }

    public static boolean isExplicit(JsonObject trackObj) {
        return trackObj.get("item").getAsJsonObject().get("explicit").getAsBoolean();
    }

    public static void reloadData(boolean forceFullReload, Runnable onNoUpdate, Runnable onDataUpdate, Runnable onImageLoad) {
        ApiCalls.getNowPlayingTrack(data -> {
            boolean isSongDifferent = !SongDataExtractor.getId(data).equals(SongData.Id);
            SongData.progressLabel = SongDataExtractor.getProgressLabel(data);
            SongData.isPlaying = SongDataExtractor.isPlaying(data);
            SongData.progressValue = SongDataExtractor.getDuration(data);
            if (isSongDifferent || forceFullReload) {
                SongData.title = (SongDataExtractor.isExplicit(data) ? "\ud83c\udd74 " : "") + SongDataExtractor.getName(data);
                SongData.artist = SongDataExtractor.getArtist(data);
                SongData.durationLabel = SongDataExtractor.getDurationLabel(data);
                SongData.Id = SongDataExtractor.getId(data);
                SongData.duration = SongDataExtractor.getMaxDuration(data);
                SongData.songURI = SongDataExtractor.getSpotifyLink(data);
                if (!SongData.coverImage.method_12832().equals("ui/nothing.png")) {
                    SongData.coverImage = class_2960.method_60655((String)"media", (String)"ui/nothing.png");
                }
                CompletableFuture<class_2960> ImageIOFuture = CompletableFuture.supplyAsync(() -> SongDataExtractor.getAlbumCover(data));
                ImageIOFuture.thenAccept(id -> {
                    SongData.coverImage = id;
                    onImageLoad.run();
                });
            }
            if (isSongDifferent || forceFullReload) {
                onDataUpdate.run();
            } else {
                onNoUpdate.run();
            }
        });
    }
}

