/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc;

import com.mojang.logging.LogUtils;
import net.beastguy.distantlandsmc.Config;
import net.beastguy.distantlandsmc.block.ModBlocks;
import net.beastguy.distantlandsmc.block.entity.ModBlockEntities;
import net.beastguy.distantlandsmc.block.entity.renderer.PedestalBlockEntityRenderer;
import net.beastguy.distantlandsmc.common.crawl.Crawl;
import net.beastguy.distantlandsmc.component.ModDataComponentTypes;
import net.beastguy.distantlandsmc.effect.ModEffects;
import net.beastguy.distantlandsmc.enchantment.ModEnchantmentEffects;
import net.beastguy.distantlandsmc.entity.ModEntity;
import net.beastguy.distantlandsmc.entity.client.butterfly.ButterflyRenderer;
import net.beastguy.distantlandsmc.entity.custom.boat.ModBoatRenderer;
import net.beastguy.distantlandsmc.item.ModArmorMaterials;
import net.beastguy.distantlandsmc.item.ModCreativeModeTabs;
import net.beastguy.distantlandsmc.item.ModItems;
import net.beastguy.distantlandsmc.payloads.CarpenterTableOpenPayload;
import net.beastguy.distantlandsmc.payloads.SyncRecipeOrderPayload;
import net.beastguy.distantlandsmc.potion.ModPotions;
import net.beastguy.distantlandsmc.recipe.ModRecipeTypes;
import net.beastguy.distantlandsmc.recipe.RecipeSorter;
import net.beastguy.distantlandsmc.screen.ModMenuTypes;
import net.beastguy.distantlandsmc.screen.custom.CarpenterTableMenu;
import net.beastguy.distantlandsmc.screen.custom.CarpenterTableScreen;
import net.beastguy.distantlandsmc.screen.custom.PedestalScreen;
import net.beastguy.distantlandsmc.sound.ModSounds;
import net.beastguy.distantlandsmc.util.ModItemProperties;
import net.beastguy.distantlandsmc.villager.ModVillagers;
import net.beastguy.distantlandsmc.worldgen.biome.ModBiomes;
import net.beastguy.distantlandsmc.worldgen.biome.ModSurfaceRules;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;
import terrablender.api.SurfaceRuleManager;

@Mod(value="distantlandsmc")
public class DistantLandsMod {
    public static final String MODID = "distantlandsmc";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static ResourceLocation rl(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)s);
    }

    public DistantLandsMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(DistantLandsMod::registerPacket);
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModArmorMaterials.register(modEventBus);
        ModDataComponentTypes.register(modEventBus);
        ModSounds.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModEffects.register(modEventBus);
        ModPotions.register(modEventBus);
        ModVillagers.register(modEventBus);
        ModEnchantmentEffects.register(modEventBus);
        ModEntity.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipeTypes.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.PETUNIA.getId(), ModBlocks.POTTED_PETUNIA);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.HARU_SAPLING.getId(), ModBlocks.POTTED_HARU_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.JACARANDA_SAPLING.getId(), ModBlocks.POTTED_JACARANDA_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.PAU_BRASIL_SAPLING.getId(), ModBlocks.POTTED_PAU_BRASIL_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.IPE_AMARELO_SAPLING.getId(), ModBlocks.POTTED_IPE_AMARELO_SAPLING);
        });
        ModBiomes.registerBiomes();
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.END, (String)MODID, (SurfaceRules.RuleSource)ModSurfaceRules.makeEndRotRules());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MODID, (SurfaceRules.RuleSource)ModSurfaceRules.makeLavenderGroveRules());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MODID, (SurfaceRules.RuleSource)ModSurfaceRules.makeBloomingJacarandaGroveRules());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MODID, (SurfaceRules.RuleSource)ModSurfaceRules.makePauBrasilForestRules());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MODID, (SurfaceRules.RuleSource)ModSurfaceRules.makeYellowIpeGroveRules());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            // empty if block
        }
    }

    public static void registerPacket(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(Crawl.Payload.ID, Crawl.Payload.CODEC, (payload, context) -> {
            MinecraftServer server = context.player().getServer();
            if (server != null) {
                server.execute(() -> context.player().getEntityData().set(Crawl.Shared.CRAWL_REQUEST, (Object)payload.crawl()));
            }
        });
        Crawl.crawlRequestPacket = wantsToCrawl -> PacketDistributor.sendToServer((CustomPacketPayload)new Crawl.Payload((boolean)wantsToCrawl), (CustomPacketPayload[])new CustomPacketPayload[0]);
        registrar.playToServer(CarpenterTableOpenPayload.ID, CarpenterTableOpenPayload.CODEC, (payload, context) -> {
            MinecraftServer server = context.player().getServer();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                Player player = context.player();
                Level level = player.level();
                if (level.getBlockState(payload.pos()).getBlock() == ModBlocks.CARPENTER_TABLE.get()) {
                    player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new CarpenterTableMenu(containerId, inventory, ContainerLevelAccess.create((Level)p.level(), (BlockPos)payload.pos())), (Component)Component.translatable((String)"container.carpenter_table")));
                }
            });
        });
        registrar.playToClient(SyncRecipeOrderPayload.TYPE, SyncRecipeOrderPayload.CODEC, (payload, context) -> context.enqueueWork(() -> RecipeSorter.acceptOrder(payload.list())));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="distantlandsmc", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModItemProperties.addCustomItemProperties();
            EntityRenderers.register(ModEntity.MOD_BOAT.get(), context -> new ModBoatRenderer(context, false));
            EntityRenderers.register(ModEntity.MOD_CHEST_BOAT.get(), context -> new ModBoatRenderer(context, true));
            EntityRenderers.register(ModEntity.BUTTERFLY.get(), ButterflyRenderer::new);
        }

        @SubscribeEvent
        public static void onClientExtensions(RegisterClientExtensionsEvent event) {
        }

        @SubscribeEvent
        public static void registerColoredBlocks(RegisterColorHandlersEvent.Block event) {
        }

        @SubscribeEvent
        public static void registerColoredItems(RegisterColorHandlersEvent.Item event) {
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.PEDESTAL_BE.get(), PedestalBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.PEDESTAL_MENU.get(), PedestalScreen::new);
            event.register((MenuType)ModMenuTypes.CARPENTER_TABLE_MENU.get(), CarpenterTableScreen::new);
        }
    }
}

