/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.block.custom;

import java.util.List;
import net.beastguy.distantlandsmc.entity.custom.ButterflyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ButterflyJarBlock
extends Block {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.box((double)3.5, (double)13.0, (double)3.5, (double)12.5, (double)15.0, (double)12.5)});

    public ButterflyJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(@NotNull BlockState oldState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moved) {
        super.onRemove(oldState, level, pos, newState, moved);
        this.releaseButterflies((LevelAccessor)level, pos);
    }

    private void releaseButterflies(LevelAccessor level, BlockPos pos) {
        List butterflies = level.getEntitiesOfClass(ButterflyEntity.class, new AABB(pos));
        for (ButterflyEntity butterfly : butterflies) {
            butterfly.setNoAi(false);
            butterfly.setInvulnerable(false);
            butterfly.setInJar(false);
            butterfly.setPersistenceRequired();
            butterfly.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, level.getRandom().nextFloat() * 360.0f, 0.0f);
        }
    }
}

