/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.block.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.beastguy.distantlandsmc.screen.custom.CarpenterTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CarpenterTableBlock
extends Block {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.carpenter_table");
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape PART_1 = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape PART_3 = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)3.0);
    private static final VoxelShape PART_4 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)8.0, (double)3.0);
    private static final VoxelShape PART_5 = Block.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)8.0, (double)16.0);
    private static final VoxelShape PART_6 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_BOTTOM = Shapes.or((VoxelShape)PART_1, (VoxelShape[])new VoxelShape[]{PART_3, PART_4, PART_5, PART_6});
    private static final VoxelShape SHAPE_TOP_PART1 = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_TOP_PART2 = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_TOP = Shapes.or((VoxelShape)SHAPE_TOP_PART1, (VoxelShape)SHAPE_TOP_PART2);

    public CarpenterTableBlock() {
        super(BlockBehaviour.Properties.of().destroyTime(2.5f).explosionResistance(2.5f).sound(SoundType.WOOD).mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BOTTOM});
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        double clickY = context.getClickLocation().y - (double)pos.getY();
        return face != Direction.DOWN && (face == Direction.UP || clickY <= 0.5) ? state : (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return new SimpleMenuProvider((i, inventory, player) -> new CarpenterTableMenu(i, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape baseShape = (Boolean)state.getValue((Property)BOTTOM) != false ? SHAPE_BOTTOM : SHAPE_TOP;
        Direction facing = (Direction)state.getValue((Property)FACING);
        return CarpenterTableBlock.rotateShape(facing, baseShape);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    private static VoxelShape rotateShape(Direction to, VoxelShape shape) {
        if (Direction.NORTH == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - Direction.NORTH.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.distantlandsmc.carpenter_table.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

