/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PabbleBlock_1
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE_0 = Block.box((double)2.0, (double)0.0, (double)11.0, (double)4.0, (double)1.0, (double)13.0);
    private static final VoxelShape SHAPE_1 = Block.box((double)4.0, (double)0.0, (double)6.0, (double)7.0, (double)1.0, (double)9.0);
    private static final VoxelShape SHAPE_2 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)1.0, (double)4.0);
    private static final VoxelShape SHAPE_3 = Block.box((double)5.0, (double)0.0, (double)2.0, (double)7.0, (double)1.0, (double)4.0);
    private static final VoxelShape SHAPE_4 = Block.box((double)12.0, (double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)3.0);
    private static final VoxelShape SHAPE_5 = Block.box((double)7.0, (double)0.0, (double)10.0, (double)10.0, (double)1.0, (double)12.0);
    private static final VoxelShape SHAPE_6 = Block.box((double)11.0, (double)0.0, (double)12.0, (double)14.0, (double)1.0, (double)14.0);
    private static final VoxelShape SHAPE_7 = Block.box((double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)1.0, (double)12.0);
    private static final VoxelShape SHAPE_8 = Block.box((double)9.0, (double)0.0, (double)4.0, (double)13.0, (double)1.0, (double)7.0);
    private static final VoxelShape SHAPE_9 = Block.box((double)9.0, (double)0.0, (double)7.0, (double)12.0, (double)1.0, (double)8.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_0, (VoxelShape[])new VoxelShape[]{SHAPE_1, SHAPE_2, SHAPE_3, SHAPE_4, SHAPE_5, SHAPE_6, SHAPE_7, SHAPE_8, SHAPE_9});

    public PabbleBlock_1() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops().isSuffocating((state, getter, pos) -> false).isViewBlocking((state, getter, pos) -> false).isRedstoneConductor((state, getter, pos) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return PabbleBlock_1.rotateShape(facing);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return PabbleBlock_1.rotateShape(facing);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    private static VoxelShape rotateShape(Direction to) {
        VoxelShape[] buffer = new VoxelShape[]{SHAPE, Shapes.empty()};
        int times = (to.get2DDataValue() - Direction.NORTH.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }
}

