/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StickBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE_0 = Block.box((double)6.9, (double)0.0, (double)3.8, (double)8.1, (double)0.6, (double)5.0);
    private static final VoxelShape SHAPE_1 = Block.box((double)8.1, (double)0.0, (double)4.4, (double)8.7, (double)0.6, (double)9.2);
    private static final VoxelShape SHAPE_2 = Block.box((double)11.1, (double)0.0, (double)4.4, (double)12.3, (double)0.6, (double)5.6);
    private static final VoxelShape SHAPE_3 = Block.box((double)7.5, (double)0.0, (double)5.0, (double)8.1, (double)0.6, (double)6.2);
    private static final VoxelShape SHAPE_4 = Block.box((double)8.7, (double)0.0, (double)5.0, (double)9.3, (double)0.6, (double)8.6);
    private static final VoxelShape SHAPE_5 = Block.box((double)10.5, (double)0.0, (double)5.0, (double)11.1, (double)0.6, (double)6.8);
    private static final VoxelShape SHAPE_6 = Block.box((double)9.9, (double)0.0, (double)5.6, (double)10.5, (double)0.6, (double)7.4);
    private static final VoxelShape SHAPE_7 = Block.box((double)11.1, (double)0.0, (double)5.6, (double)11.7, (double)0.6, (double)6.2);
    private static final VoxelShape SHAPE_8 = Block.box((double)9.3, (double)0.0, (double)6.2, (double)9.9, (double)0.6, (double)8.0);
    private static final VoxelShape SHAPE_9 = Block.box((double)7.5, (double)0.0, (double)7.4, (double)8.1, (double)0.6, (double)9.8);
    private static final VoxelShape SHAPE_10 = Block.box((double)6.9, (double)0.0, (double)8.6, (double)7.5, (double)0.6, (double)10.4);
    private static final VoxelShape SHAPE_11 = Block.box((double)6.3, (double)0.0, (double)9.2, (double)6.9, (double)0.6, (double)11.0);
    private static final VoxelShape SHAPE_12 = Block.box((double)5.7, (double)0.0, (double)9.8, (double)6.3, (double)0.6, (double)11.6);
    private static final VoxelShape SHAPE_13 = Block.box((double)5.1, (double)0.0, (double)10.4, (double)5.7, (double)0.6, (double)12.2);
    private static final VoxelShape SHAPE_14 = Block.box((double)4.5, (double)0.0, (double)11.0, (double)5.1, (double)0.6, (double)12.2);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_0, (VoxelShape[])new VoxelShape[]{SHAPE_1, SHAPE_2, SHAPE_3, SHAPE_4, SHAPE_5, SHAPE_6, SHAPE_7, SHAPE_8, SHAPE_9, SHAPE_10, SHAPE_11, SHAPE_12, SHAPE_13, SHAPE_14});

    public StickBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(0.1f).noOcclusion().isSuffocating((state, getter, pos) -> false).isViewBlocking((state, getter, pos) -> false).isRedstoneConductor((state, getter, pos) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return StickBlock.rotateShape(facing);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return StickBlock.rotateShape(facing);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    private static VoxelShape rotateShape(Direction to) {
        VoxelShape[] buffer = new VoxelShape[]{SHAPE, Shapes.empty()};
        int times = (to.get2DDataValue() - Direction.NORTH.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }
}

